<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Router\Route;
use TourOperatorProFrontend\app\helpers\CurrencyHelper;
use TourOperatorProFrontend\app\helpers\FrontendHelper;

$tour = $this->tour;
$new_price = $tour ->price;
if($tour->discount) {
    if($tour->discount->amount > 0) {
        $new_price = $tour->price - $tour->discount->amount;
    } else if ($tour->discount->percent > 0) {
        $new_price= $tour->price - ($tour->price * $tour->discount->percent) / 100 ;
    }
}
$max_star = 5;
$tour_rating=$tour->rating;
while ($tour_rating > $max_star) {
    $tour_rating = $tour_rating - $max_star;
}

$star = $tour_rating % 10;
$non_star = ($max_star - $tour_rating) % 10;
$half_star = ceil($max_star-$star-$non_star);
?>
<div class="block-tour-item">
    <input type="hidden" name="tour_id" value="<?php echo ($tour->id)?>"/>
    <div class="content-top">
        <div class="block-img">
            <div>
                <img src="<?php echo (Factory::getRootUrlPlugin());?><?php echo ($tour->image);?>" >
            </div>
        </div>
        <div class="block-feature">
            <div class="label-feature <?php esc_attr_e($tour->is_feature==1 ? 'visible':'');?>">
                <span><?php esc_attr_e('Featured','touroperatorpro');?></span>
            </div>
            <i class="fas fa-heart"></i>
        </div>
        <?php if($tour->discount) {?>
            <?php if($tour->discount->amount > 0) {?>>
                <span class="box-sale">- $<?php esc_html_e($tour->discount->amount);?></span>
            <?php } if($tour->discount->percent > 0) {?>
                <span class="box-sale"><?php esc_html_e($tour->discount->percent);?>%</span>
            <?php }?>
        <?php }?>
    </div>
    <div class="content-bottom">
        <p class="place-tour">
            <i class="icon-nb-pin"></i>
            <?php
                if(isset(end($tour->list_destination)->address)){
                    esc_html_e(end($tour->list_destination)->address);
                }
            ?>
        </p>
        <h4 class="name-tour">
            <a href="<?php echo Route::_($this->page_tour_detail.'?tour_id='.$tour->id,0); ?>">
                <?php esc_html_e($tour->name);?>
            </a>
        </h4>
        <div class="block-rating">
            <ul class="list-rating-star">
                <?php if($tour->rating > 0) {?>
                    <?php for ($i=0; $i <$star; $i++) {?>
                        <li class="item-star"><i class="fas fa-star"></i></li>
                    <?php }?>
                    <?php for ($i=0; $i <$half_star; $i++) {?>
                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                    <?php }?>
                    <?php for ($i=0; $i <$non_star; $i++) {?>
                        <li class="item-star"><i class="far fa-star"></i></li>
                    <?php }?>
                <?php }?>
            </ul>
            <div class="rating-review">
                <span>2 <?php esc_attr_e('Reviews','touroperatorpro');?></span>
            </div>
        </div>
        <div class="block-price-sale">
            <?php if($tour->discount) {?>
                <span><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$tour->price)));?></span>
            <?php } else {?>
                <span></span>
            <?php }?>
        </div>
        <div class="block-trip-price">
            <div class="time-trip">
                <i class="icon-nb-clock"></i>
                <span><?php echo ($tour->duration);?> <?php esc_attr_e('Days','touroperatorpro');?></span>
            </div>
            <div class="price-tour">
                <span><i class="fas fa-bolt"></i><span><?php esc_attr_e('From','touroperatorpro');?></span></span>
                <span class="price"><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$new_price)));?></span>
            </div>
        </div>
    </div>
</div>
