<?php
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\TourOperatorProHtmlFrontend;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$doc= FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-tours.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
TourOperatorProHtmlFrontend::load_jquery_library('datatables');
TourOperatorProHtmlFrontend::load_jquery_library('moment');
TourOperatorProHtmlFrontend::load_jquery_library('daterangepicker');
TourOperatorProHtmlFrontend::load_jquery_library('fontawesome');
TourOperatorProHtmlFrontend::load_jquery_library('ui');
TourOperatorProHtmlFrontend::load_jquery_library('icheck');
TourOperatorProHtmlFrontend::load_jquery_library('select2');
TourOperatorProHtmlFrontend::load_jquery_library('twbs_pagination');
TourOperatorProHtmlFrontend::load_jquery_library('cookie_js');
TourOperatorProHtmlFrontend::load_jquery_library('icheck');
TourOperatorProHtmlFrontend::load_jquery_library('select2');
TourOperatorProHtmlFrontend::load_jquery_library('loading_js');
TourOperatorProHtmlFrontend::load_jquery_library('datatables');
$page_tour_detail= ConfigHelperAlias::get_page_tour_detail();
if($page_tour_detail) {
    $this->page_tour_detail = get_page_link($page_tour_detail);
}else{
    $this->page_tour_detail="";
}
$number_tour=count($this->list);
$page_list_tour= ConfigHelperAlias::get_page_list_tour();
if($page_list_tour) {
    $page_list_tour = get_page_link($page_list_tour);
}else{
    $page_list_tour="";
}
$input=FactoryAlias::getInput();
$destination_id=$input->getInt('destination',0);
$list_tourtype_id=[];
if(array_key_exists('tour_type',(array)$input->getData())) {
    $list_tourtype_id=(array)$input->getData()['tour_type'];
}

$date_time = $input->getString('rate','');
$price_search = $input->getString('price_search','');
$price_search = json_decode($price_search);
if(is_array($price_search) && !empty($price_search) && count($price_search) == 2) {
    $min_price_search = min($price_search);
    $max_price_search = max($price_search);
} else {
    $min_price_search = 0;
    $max_price_search = 1099;
}
$render_tour_item_grid = function (){
    ob_start();
    ?>
    <?php foreach ($this->list as $tour){ ?>
        <?php
        $this->tour=$tour;
        ?>
        <div class="col-sm-6 col-md-4 tour-render-item"><?php $this->loadTemplate('list_item') ?></div>
    <?php } ?>
    <?php
    $content = ob_get_clean();
    return $content;
};
$render_tour_item_list = function (){
    ob_start();
    ?>
    <?php foreach ($this->list as $tour){ ?>
        <?php
        $this->tour=$tour;
        ?>
        <div class="tour-render-item">
            <?php $this->loadTemplate('list_row_item') ?>
        </div>
    <?php } ?>
    <?php
    $content = ob_get_clean();
    return $content;
}

?>
    <div class="view-list-tours">
        <div class="row">
            <div class="col-md-3">
                <?php
                echo ($this->form->renderField('change_currency'))
                ?>
                <div class="wrapper-search-tour">
                    <form action="<?php echo ($page_list_tour)  ?>" method="post" class="form-search-tour">
                        <div class="block-title-search-tour">
                            <h4><?php esc_attr_e('Search tours','touroperatorpro');?></h4>
                        </div>
                        <div class="block-select-destination">
                            <i class="icon-nb-pin"></i>
                            <label><?php esc_attr_e('Destination','touroperatorpro');?></label>
                            <select name="destination" class="select-destination">
                                <option><?php esc_attr_e('Where are you going','touroperatorpro');?></option>
                                <?php foreach ($this->list_country as $country) {?>
                                    <optgroup label="<?php echo ($country->countryname);?>">
                                        <?php foreach ($country->list_location as $location) {?>
                                            <option <?php echo (($destination_id==$location->location_id)?'selected':'') ?> value="<?php echo ($location->location_id);?>"><?php echo ($location->location_name);?></option>
                                        <?php }?>
                                    </optgroup>
                                <?php }?>
                            </select>
                        </div>
                        <div class="block-select-date">
                            <i class="icon-nb-calendar"></i>
                            <label for=""><?php esc_attr_e('From','touroperatorpro');?>-<?php esc_attr_e('To','touroperatorpro');?></label>
                            <input type="text" class="datetimes" value="<?php echo(esc_attr(str_replace(array('-',';'),array('/', ' - '), $date_time)))?>"/>
                            <input type="hidden" name="rate" value="<?php echo(esc_attr($date_time))?>"/>
                        </div>
                        <div class="block-more-option">
                            <div class="title-more-option">
                                <p class="more-option"><span><?php esc_attr_e('More option','touroperatorpro');?></span><i class="fas fa-sort-down"></i></p>
                                <div class="block-filter-price block-filter-price-more-option">
                                    <h5><?php esc_attr_e('Filter price','touroperatorpro');?></h5>
                                    <input type="text" id="amount_1" readonly/>
                                    <div id="slider-container-1"></div>
                                    <input type="hidden" name="price_search">
                                </div>
                                <div class="block-tour-categories">
                                    <h5><?php esc_attr_e('Tour type','touroperatorpro');?></h5>
                                    <div class="block-tour-type-item">
                                        <?php foreach ($this->list_tourtype as $tour_type) {?>
                                            <?php if (count((array)$list_tourtype_id)) {?>
                                                <label><input <?php echo (in_array($tour_type->id,$list_tourtype_id)?'checked':'')?> type="checkbox" name="tour_type[]" value="<?php echo ($tour_type->id);?>"/> <span><?php echo ($tour_type->name);?></span></label>
                                            <?php } else {?>
                                                <label><input type="checkbox" name="tour_type[]" value="<?php echo ($tour_type->id);?>"/> <span><?php echo ($tour_type->name);?></span></label>
                                            <?php }?>
                                        <?php }?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="block-button-search">
                            <button type="submit" class="btn btn-primary"><?php esc_attr_e('Search','touroperatorpro');?></button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-md-9">
                <?php if($number_tour > 0) {?>
                    <div class="wrapper-block-result">
                        <div class="block-top-result">
                            <div class="result-title">
                                <h3><?php echo ($number_tour) ?> <?php esc_attr_e('Tours found','touroperatorpro');?></h3>
                            </div>
                            <div class="block-sorting-display">
                                <div class="block-display-button">
                                    <ul class="nav nav-tabs">
                                        <li class="active"><a data-toggle="tab" href="#grid-display"><i class="icon-nb-list"></i></a></li>
                                        <li><a data-toggle="tab" href="#list-display"><i class="icon-nb-grid"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content wrapper-result-body">
                            <div id="grid-display" class="tab-pane fade in active">
                                <div class="row wrapper-tour-grid">
                                    
                                </div>
                            </div>
                            <div id="list-display" class="tab-pane fade">
                                <div class="row wrapper-tour-list">
                                    
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <ul class="pagination-tour"></ul>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } else {?>
                <div class="wrapper-block-result">
                    <div class="block-top-result">
                        <div class="result-title">
                            <h3><?php echo ($number_tour) ?> <?php esc_attr_e('Could not find any tours','touroperatorpro');?></h3>
                        </div>
                        <div class="block-sorting-display">
                            <div class="block-display-button">
                                <ul class="nav nav-tabs">
                                    <li class="active"><a data-toggle="tab" href="#grid-display"><i class="fas fa-th"></i></a></li>
                                    <li><a data-toggle="tab" href="#list-display"><i class="fas fa-list"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="tab-content wrapper-result-body">
                        <div id="grid-display" class="tab-pane fade in active">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="alert-block">
                                        <span><?php esc_attr_e('Could not find any tours','touroperatorpro')?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="list-display" class="tab-pane fade">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="alert-block">
                                        <span><?php esc_attr_e('Could not find any tours','touroperatorpro')?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php }?>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-tours','view_list_tours',array(
        'data_input'=>$input->getData(),
        "render_tour_item_grid"=>$render_tour_item_grid(),
        "render_tour_item_list"=>$render_tour_item_list(),
        "min_price"=>$min_price_search,
        "max_price"=>$max_price_search
),"frontend/app/assets/js/view_list_tours.js");
?>