<?php
namespace TourOperatorProFrontend\app\views\tours;
use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorProAdmin\app\controllers\TourController;
use TourOperatorProFrontend\app\controllers\ToursController;

class ToursView extends View
{
    public function display($tpl){
        $modelTours=Model::getInstance('tours');
        $this->list=$modelTours->getList();
        $modelTour=Model::getInstance('tour');
        $this->form = $modelTour->getForm();
        $modelCurrencies=Model::getInstance('currencies');
        $appConfig = Factory::getAppConfig();
        $symbol = $appConfig->get('currencies_in_list', '');
        $currencyModel = Model::getInstance('currency');
       if (isset($_SESSION["currency"])){
            $currency = $_SESSION["currency"];
            $this->symbol = $currencyModel->format_currency($currency);
        }else{
           $this->symbol = $currencyModel->format_currency($symbol);
        }
        $this->listCurrencies = $modelCurrencies->getList();
        $this->list_country = $modelTours->getList_destination();
        $this->list_tourtype= $modelTours->getList_tourtype();

        $this->max_price= $modelTours->getMaxPrice();
        $this->totalRecord= $modelTours->getTotalRecord();

        return parent::display($tpl);
    }
}