<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\TourOperatorProHtmlFrontend;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorProFrontend\app\helpers\ConfigHelper;
use TourOperatorProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use TourOperatorProFrontend\app\helpers\FrontendHelper;

$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-tourlocator.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
TourOperatorProHtmlFrontend::load_jquery_library('datatables');
TourOperatorProHtmlFrontend::load_jquery_library('moment');
TourOperatorProHtmlFrontend::load_jquery_library('daterangepicker');
TourOperatorProHtmlFrontend::load_jquery_library('fontawesome');
TourOperatorProHtmlFrontend::load_jquery_library('ui');
TourOperatorProHtmlFrontend::load_jquery_library('icheck');
TourOperatorProHtmlFrontend::load_jquery_library('select2');
TourOperatorProHtmlFrontend::load_jquery_library('loading_js');
TourOperatorProHtmlFrontend::load_jquery_library('confirm');
TourOperatorProHtmlFrontend::load_jquery_library('store_locator_js');
$url_plugin = TOUROPERATORPRO_PLUGIN_NAME;
$page_service_detail = ConfigHelperAlias::get_page_tour_detail();
if ($page_service_detail) {
    $this->page_service_detail = get_page_link($page_service_detail);
} else {
    $this->page_service_detail = "";
}
$number_service = count($this->list);
$page_list_service = ConfigHelperAlias::get_page_list_tour();
if ($page_list_service) {
    $page_list_service = get_page_link($page_list_service);
} else {
    $page_list_service = "";
}

$input = FactoryAlias::getInput();
$location_id = $input->getInt('location', 0);
$near_me = $input->getInt('near_me', 0);
$list_employee_id = [];
if (array_key_exists('employee', (array)$input->getData())) {
    $list_employee_id = (array)$input->getData()['employee'];
}
$list_category_id = [];
if (array_key_exists('category', (array)$input->getData())) {
    $list_category_id = (array)$input->getData()['category'];
}
?>
    <div class="view-list-tourlocator">
        <div class="row">
            <div class="col-md-12">
                <div class="bh-sl-container">
                    <div id="bh-sl-map-container" class="bh-sl-map-container">
                        <div class="bh-sl-loc-list">
                            <ul class="list"></ul>
                        </div>
                        <div id="bh-sl-map" class="bh-sl-map"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
$input = FactoryAlias::getInput();
$doc->addScriptApplySelector('.view-list-tourlocator', 'view_list_tourlocator', array(
    'data_input' => $input->getData(),
    'list_service'=>json_encode($this->list),
    'url_plugin' => $url_plugin
), "frontend/app/assets/js/view_list_tourlocator.js");
?>