<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\TourOperatorProHtmlFrontend;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\ConfigHelper;
use TourOperatorProFrontend\app\helpers\CurrencyHelper;
use TourOperatorProFrontend\app\helpers\FrontendHelper;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-tour-detail.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
TourOperatorProHtmlFrontend::load_jquery_library('datatables');
TourOperatorProHtmlFrontend::load_jquery_library('fontawesome');
TourOperatorProHtmlFrontend::load_jquery_library('moment');
TourOperatorProHtmlFrontend::load_jquery_library('daterangepicker');
TourOperatorProHtmlFrontend::load_jquery_library('owlcarousel2');
TourOperatorProHtmlFrontend::load_jquery_library('confirm');
TourOperatorProHtmlFrontend::load_jquery_library('loading_js');
$page_link_checkout = ConfigHelper::get_page_tour_checkout();
$format_currency = CurrencyHelper::format_currency_frontend();
$post_content=get_post($page_link_checkout);
if($page_link_checkout && $post_content)
{
    $page_link_checkout = get_page_link($page_link_checkout);
}
$one=1;
$zero=0;
$page_list_tour_search_result = ConfigHelper::get_page_list_tour_search_result();
$post_content=get_post($page_list_tour_search_result);
if($page_list_tour_search_result && $post_content)
{
    $page_list_tour_search_result = get_page_link($page_list_tour_search_result);
}

?>
<?php if (!empty((array)$this->tour)) { ?>
    <?php
    $tour = $this->tour;
    $new_price = $tour->price;
    if ($tour->discount) {
        if (isset($tour->discount->amount) && $tour->discount->amount > 0) {
            $new_price = $tour->price - $tour->discount->amount;
        } else if (isset($tour->discount->percent) && $tour->discount->percent > 0) {
            $new_price = $tour->price - ($tour->price * $tour->discount->percent) / 100;
        }
    }
    $max_star = 5;
    $tour_rating=$tour->rating;
    while ($tour_rating > $max_star) {
        $tour_rating = $tour_rating - $max_star;
    }

    $star = $tour_rating % 10;
    $non_star = ($max_star - $tour_rating) % 10;
    $half_star = ceil($max_star-$star-$non_star);
    $i = 1;

    ?>

    <div class="view-tour-detail">
        <div class="row">
            <div class="col-md-12">
                <div id="owl-carousel" class="owl-carousel owl-theme">
                    <?php foreach ($this->tour->gallery AS $gallery) { ?>
                        <div class="banner">
                            <div>
                                <img src="<?php echo (FactoryAlias::getRootUrlPlugin()) ?><?php echo ($gallery->path); ?>">
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-9">
                <div class="content">
                    <div class="float-left">
                        <h2><?php echo ($tour->name); ?></h2>
                        <div class="sub-heading">
                            <i class="icon-nb-adress"></i>
                            <span>
                                <?php Text::_echo_no_translate(isset(end($this->tour->destination)->address)?end($this->tour->destination)->address:''); ?>
                            </span>
                        </div>
                    </div>
                    <div class="float-right">
                        <div class="review-score style-2">
                            <?php if($tour->rating<=1 & $tour->rating>=0){?>
                            <span class="head-rating"><?php esc_attr_e('Terrible','touroperatorpro') ?></span>
                            <?php } elseif ($tour->rating<=2 & $tour->rating>1){?>
                                <span class="head-rating"><?php esc_attr_e('Poor','touroperatorpro') ?></span>
                            <?php } elseif ($tour->rating<=3 & $tour->rating>2){?>
                                <span class="head-rating"><?php esc_attr_e('Average','touroperatorpro') ?> </span>
                            <?php } elseif ($tour->rating<=4 & $tour->rating>3){?>
                                <span class="head-rating"><?php esc_attr_e('Very_good','touroperatorpro') ?> </span>
                            <?php } elseif ($tour->rating<=5 & $tour->rating>4){?>
                                <span class="head-rating"><?php esc_attr_e('Excellent','touroperatorpro') ?> </span>
                            <?php } ?>
                            <ul class="detail-stars style-2">
                                <?php if($tour->rating > 0) {?>
                                    <?php for ($i=0; $i <$star; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$half_star; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$non_star; $i++) {?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    <?php }?>
                                <?php }?>
                            </ul>
                            <p class="detail-link"><?php esc_attr_e('From 1 review','touroperatorpro'); ?></p>
                        </div>
                    </div>
                </div>
                <div class="detail-tour-feature">
                    <div class="item">
                        <div class="icon">
                            <i class="far fa-clock"></i>
                        </div>
                        <div class="info">
                            <h4 class="name"><?php esc_attr_e('Duration','touroperatorpro'); ?></h4>
                            <?php if ($tour->duration<=1){?>
                                <p class="value"><?php echo ($tour->duration); ?> <?php esc_attr_e('Day','touroperatorpro'); ?></p>
                            <?php } else{ ?>
                                <p class="value"><?php echo ($tour->duration); ?> <?php esc_attr_e('Days','touroperatorpro'); ?></p>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="item">
                        <div class="icon">
                            <i class="fas fa-shoe-prints"></i>
                        </div>
                        <div class="info">
                            <h4 class="name"><?php esc_attr_e('Tour type','touroperatorpro'); ?></h4>
                            <p class="value">
                                <?php echo (implode(',', array_map(
                                    function ($v) {
                                        return $v->name;
                                    }, $tour->tourtype
                                ))); ?>
                            </p>
                        </div>
                    </div>
                    <div class="item">
                        <div class="icon">
                            <i class="fas fa-male"></i>
                        </div>
                        <div class="info">
                            <h4 class="name"><?php esc_attr_e('Group size','touroperatorpro'); ?></h4>
                            <?php if ($tour->group_size<=1){?>
                                <p class="value"><?php echo ($tour->group_size); ?> <?php esc_attr_e('People','touroperatorpro'); ?></p>
                            <?php } else{ ?>
                                <p class="value"><?php echo ($tour->group_size); ?> <?php esc_attr_e('Peoples','touroperatorpro'); ?></p>
                            <?php } ?>

                        </div>
                    </div>
                    <div class="item">
                        <div class="icon">
                            <i class="fas fa-language"></i>
                        </div>
                        <div class="info">
                            <h4 class="name"><?php esc_attr_e('Languages','touroperatorpro'); ?></h4>
                            <p class="value"><?php echo ($this->tour->language); ?></p>
                        </div>
                    </div>
                </div>
                <div class="detail-overview">
                    <h3 class="detail-section-title"><?php esc_attr_e('Overview','touroperatorpro'); ?></h3>
                    <div class="detail-description" data-toggle-section="detail-description">
                        <p>
                            <?php echo ($this->tour->description); ?>
                        </p>
                    </div>
                </div>
                <div class="detail-highlight">
                    <h3 class="detail-section-title"><?php esc_attr_e('Highlights','touroperatorpro'); ?></h3>
                    <div class="highlight-block">
                        <?php echo ($this->tour->highlight); ?>
                    </div>
                </div>
                <div class="detail-program">
                    <div class="detail-title-wrapper">
                        <h3 class="detail-section-title"><?php esc_attr_e('Itinerary','touroperatorpro'); ?></h3>
                        <span id="expand" class="expand" data-ex="1" data-text-more="Expand All" data-text-less="Collapse All"><?php esc_attr_e('Expand all','touroperatorpro'); ?></span>
                    </div>
                    <div class="detail-program-list style1">
                        <?php
                             $i=1;
                             foreach ($this->tour->list_itinerary as $list_itinerary) { ?>
                                <div class="item">
                                    <div class="header">
                                        <h5><?php esc_attr_e('Day','touroperatorpro'); ?> <?php esc_html_e($i); ?></h5>
                                        <span class="arrow">
                                    <i class="fa fa-angle-down"></i>
                                </span>
                                    </div>
                                    <div class="body">
                                        <p>
                                            <?php echo ($list_itinerary->description); ?>
                                        </p>
                                    </div>
                                </div>
                                <?php $i++;
                             }
                         ?>
                    </div>
                </div>
                <div class="detail-include">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <h3 class="detail-section-title"><?php esc_attr_e('Included','touroperatorpro'); ?></h3>
                            <div class="include-block">
                                <?php echo ($this->tour->included); ?>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <h3 class="detail-section-title"><?php esc_attr_e('Excluded','touroperatorpro'); ?></h3>
                            <div class="exclude-block">
                                <?php echo ($this->tour->excluded); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="detail-hr large detail-height2"></div>
                <div class="detail-map-wrapper">
                    <div class="detail-flex space-between">
                        <h2 class="detail-heading-section mg0"><?php esc_html_e("Tour's location",'touroperatorpro'); ?></h2>
                        <div class="c-grey">
                            <i class="icon-nb-adress"></i>
                            <span>
                                <?php Text::_echo_no_translate(isset(end($this->tour->destination)->address)?end($this->tour->destination)->address:''); ?>
                            </span>
                        </div>
                    </div>
                    <div class="detail-map mt30">
                        <div class="map">
                            <?php Text::_echo_no_translate(html_entity_decode(isset(end($this->tour->destination)->iframe)?end($this->tour->destination)->iframe:'')); ?>
                        </div>
                    </div>
                </div>
                <div class="detail-faq">
                    <h3 class="detail-section-title"><?php esc_attr_e('Faqs','touroperatorpro'); ?></h3>
                    <div class="item">
                        <div class="header">
                            <div class="wrapper">
                                <i class="far fa-comment"></i>
                                <h5>I'm a solo traveller, is there a single supplement?</h5>
                            </div>
                            <span class="arrow"><i class="fa fa-angle-down"></i></span>
                        </div>
                        <div class="body">
                            A wonderful serenity has taken possession of my entire soul, like these sweet mornings of
                            spring
                            which I enjoy with my whole heart. I am alone and feel the charm of existence in this spot,
                            which was created for the bliss of souls like mine. I am so happy, my dear friend, so
                            absorbed
                            in the exquisite.
                        </div>
                    </div>
                </div>
                <h2 class="detail-heading-section"><?php esc_attr_e('REVIEWS','touroperatorpro'); ?></h2>
                <div class="reviews">
                    <div class="review-box">
                        <div class="row">
                            <div class="col-md-5">
                                <div class="review-box-score">
                                    <div class="review-score">
                                        <?php Text::_echo_no_translate($tour->rating); ?>
                                        <span class="per-total">/5</span>
                                    </div>
                                    <div class="review-score-text">
                                        <?php if($tour->rating<=1 & $tour->rating>=0){?>
                                            <h4 class="title st_tours"><?php esc_attr_e('Terrible','touroperatorpro') ?></h4>
                                        <?php } elseif ($tour->rating<=2 & $tour->rating>1){?>
                                            <h4 class="title st_tours"><?php esc_attr_e('Poor','touroperatorpro') ?></h4>
                                        <?php } elseif ($tour->rating<=3 & $tour->rating>2){?>
                                            <h4 class="title st_tours"><?php esc_attr_e('Average','touroperatorpro') ?>  </h4>
                                        <?php } elseif ($tour->rating<=4 & $tour->rating>3){?>
                                            <h4 class="title st_tours"><?php esc_attr_e('Very_good','touroperatorpro') ?>  </h4>
                                        <?php } elseif ($tour->rating<=5 & $tour->rating>4){?>
                                            <h4 class="title st_tours"><?php esc_attr_e('Excellent','touroperatorpro') ?>  </h4>
                                        <?php } ?>
                                    </div>
                                    <div class="review-score-base">
                                        <?php esc_attr_e('Based on','touroperatorpro'); ?>
                                        <span>1 <?php esc_attr_e('Review','touroperatorpro'); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="review-sumary">
                                    <div class="item">
                                        <div class="label">
                                            <?php esc_attr_e('Excellent','touroperatorpro'); ?>
                                        </div>
                                        <div class="progress">
                                            <?php if($tour->rating<=5 & $tour->rating>4 ){?>
                                                <div class="percent green" ></div>
                                            <?php } else{ ?>
                                                 <div class="percent darkgreen" ></div>
                                            <?php } ?>
                                        </div>
                                        <?php if($tour->rating<=5 & $tour->rating>4){?>
                                            <div class="number"><?php Text::_echo_no_translate($one); ?></div>
                                        <?php } else{ ?>
                                            <div class="number"><?php Text::_echo_no_translate($zero); ?></div>
                                        <?php } ?>
                                    </div>
                                    <div class="item">
                                        <div class="label">
                                            <?php esc_attr_e('Very good','touroperatorpro'); ?>
                                        </div>
                                        <div class="progress">
                                            <?php if($tour->rating<=4 & $tour->rating>3){?>
                                                <div class="percent green" ></div>
                                            <?php } else{ ?>
                                                <div class="percent darkgreen" ></div>
                                            <?php } ?>
                                        </div>
                                        <?php if($tour->rating<=4 & $tour->rating>3){?>
                                            <div class="number"><?php Text::_echo_no_translate($one); ?></div>
                                        <?php } else{ ?>
                                            <div class="number"><?php Text::_echo_no_translate($zero); ?></div>
                                        <?php } ?>
                                    </div>
                                    <div class="item">
                                        <div class="label">
                                            <?php esc_attr_e('Average','touroperatorpro'); ?>
                                        </div>
                                        <div class="progress">
                                            <?php if($tour->rating<=3 & $tour->rating>2){?>
                                                <div class="percent green" ></div>
                                            <?php } else{ ?>
                                                <div class="percent darkgreen" ></div>
                                            <?php } ?>
                                        </div>
                                        <?php if($tour->rating<=3 & $tour->rating>2){?>
                                            <div class="number"><?php Text::_echo_no_translate($one); ?></div>
                                        <?php } else{ ?>
                                            <div class="number"><?php Text::_echo_no_translate($zero); ?></div>
                                        <?php } ?>
                                    </div>
                                    <div class="item">
                                        <div class="label">
                                            <?php esc_attr_e('Poor','touroperatorpro'); ?>
                                        </div>
                                        <div class="progress">
                                            <?php if($tour->rating<=2 & $tour->rating>1){?>
                                                <div class="percent green" ></div>
                                            <?php } else{ ?>
                                                <div class="percent darkgreen" ></div>
                                            <?php } ?>
                                        </div>
                                        <?php if($tour->rating<=2 & $tour->rating>1){?>
                                            <div class="number"><?php Text::_echo_no_translate($one); ?></div>
                                        <?php } else{ ?>
                                            <div class="number"><?php Text::_echo_no_translate($zero); ?></div>
                                        <?php } ?>
                                    </div>
                                    <div class="item">
                                        <div class="label">
                                            <?php esc_attr_e('Terrible','touroperatorpro'); ?>
                                        </div>
                                        <div class="progress">
                                            <?php if($tour->rating<=1 & $tour->rating>0){?>
                                                <div class="percent green" ></div>
                                            <?php } else{ ?>
                                                <div class="percent darkgreen" ></div>
                                            <?php } ?>
                                        </div>
                                        <?php if($tour->rating<=1 & $tour->rating>0){?>
                                            <div class="number"><?php Text::_echo_no_translate($one); ?></div>
                                        <?php } else{ ?>
                                            <div class="number"><?php Text::_echo_no_translate($zero); ?></div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="review-pagination">
                        <div class="summary">
                        </div>
                        <div id="reviews" class="review-list">
                            <div class="comment-item">
                                <div class="comment-item-head">
                                    <div class="media">
                                        <div class="media-left">
                                            <i class="fas fa-user"></i>
                                        </div>
                                        <div class="media-body">
                                            <h4 class="media-heading"><?php esc_attr_e('Admin','touroperatorpro') ?></h4>
                                            <div class="date">11/01/2020</div>
                                        </div>
                                    </div>
                                    <div class="like">
                                        <span>0</span> likes this <a data-id="27" href="#" class="btn-like st-like-review ">
                                            <i class="fa fa-thumbs-o-up"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="comment-item-body">
                                    <?php if($tour->rating<=1 & $tour->rating>=0){?>
                                        <h4 class="title st_tours"><?php esc_attr_e('Terrible','touroperatorpro') ?></h4>
                                    <?php } elseif ($tour->rating<=2 & $tour->rating>1){?>
                                        <h4 class="title st_tours"><?php esc_attr_e('Poor','touroperatorpro') ?></h4>
                                    <?php } elseif ($tour->rating<=3 & $tour->rating>2){?>
                                        <h4 class="title st_tours"><?php esc_attr_e('Average','touroperatorpro') ?>  </h4>
                                    <?php } elseif ($tour->rating<=4 & $tour->rating>3){?>
                                        <h4 class="title st_tours"><?php esc_attr_e('Very_good','touroperatorpro') ?>  </h4>
                                    <?php } elseif ($tour->rating<=5 & $tour->rating>4){?>
                                        <h4 class="title st_tours"><?php esc_attr_e('Excellent','touroperatorpro') ?>  </h4>
                                    <?php } ?>
                                    <ul class="review-star">
                                        <?php if($tour->rating > 0) {?>
                                            <?php for ($i=0; $i <$star; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$half_star; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$non_star; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php }?>
                                    </ul>
                                    <div class="detail">
                                        <div class="st-description" data-show-all="st-description-27">
                                            Varius massa maecenas et id dictumst mattis. Donec fringilla ac parturient
                                            posuere id phasellus erat elementum nullam lacus cursus rhoncus parturient
                                            vitae
                                            praesent quisque nascetur molestie quis
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="widgets">
                    <div class="form-book-wrapper">
                        <div class="form-head">
                            <div class="old-price">
                                <?php if ($tour->discount) { ?>
                                    <span class="price-original"><?php esc_html_e(FrontendHelper::format_currency($tour->price)); ?></span>
                                <?php } else { ?>
                                    <span class="price-original"></span>
                                <?php } ?>
                            </div>
                            <div class="price">
                                <span class="label"><?php esc_attr_e('From','touroperatorpro'); ?></span>
                                <span class="value">
                                <span class="text-lg lh1em item total-price ">
                                    <?php esc_html_e(CurrencyHelper::convertCurrencyFront($new_price)); ?>
                                </span>
                            </span>
                            </div>
                            <?php if ($tour->discount) { ?>
                                <?php if ($tour->discount->amount > 0) { ?>>
                                    <span class="box-sale">- $<?php echo ($tour->discount->amount); ?></span>
                                <?php }
                                if ($tour->discount->percent > 0) { ?>
                                    <span class="box-sale"><?php echo ($tour->discount->percent); ?>%</span>
                                <?php } ?>
                            <?php } ?>
                        </div>
                        <form action="<?php echo ($page_link_checkout . '?tour_id=' . $this->tour->id); ?>" method="post">
                            <div class=" form-group form-date-search">
                                <div class="date-wrapper clearfix">
                                    <div class="check-in-wrapper">
                                        <label for="datetimes"><?php esc_attr_e('DATE','touroperatorpro'); ?></label>
                                        <input type="text" class="date-check-in" id="datetimes" value="">
                                        <input type="hidden" name="date_check_in">
                                        <i class="fa fa-angle-down arrow"></i>
                                    </div>
                                </div>
                            </div>
                            <div data-group_key="adult" class=" form-group clearfix adult group-adult-children-infant">
                                <div class="guest-wrapper">
                                    <div class="check-in-wrapper">
                                        <label><?php esc_attr_e('Adults','touroperatorpro'); ?></label>
                                        <p class="render"><?php esc_attr_e('Age','touroperatorpro'); ?> 18+</p>
                                    </div>
                                    <div class="select-wrapper">
                                        <i class="fas fa-minus"></i>
                                        <input class="input-adult" type="text" value="1">
                                        <input type="hidden" name="adult_number" value="0">
                                        <i class="fas fa-plus"></i>
                                    </div>
                                </div>
                            </div>
                            <div data-group_key="children"
                                 class=" form-group clearfix children group-adult-children-infant">
                                <div class="guest-wrapper">
                                    <div class="check-in-wrapper">
                                        <label><?php esc_attr_e('Children','touroperatorpro'); ?></label>
                                        <p class="render"><?php esc_attr_e('Age','touroperatorpro'); ?> 6-17</p>
                                    </div>
                                    <div class="select-wrapper">
                                        <i class="fas fa-minus"></i>
                                        <input class="input-children" type="text" value="0">
                                        <input type="hidden" name="children_number" value="0">
                                        <i class="fas fa-plus"></i>
                                    </div>
                                </div>
                            </div>
                            <div data-group_key="infant" class=" form-group clearfix infant group-adult-children-infant">
                                <div class="guest-wrapper">
                                    <div class="check-in-wrapper">
                                        <label><?php esc_attr_e('Infant','touroperatorpro'); ?></label>
                                        <p class="render"><?php esc_attr_e('Age','touroperatorpro'); ?> 0-5</p>
                                    </div>
                                    <div class="select-wrapper">
                                        <i class="fas fa-minus"></i>
                                        <input class="input-infant" type="text" value="0">
                                        <input type="hidden" name="infant_number" value="0">
                                        <i class="fas fa-plus"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="coupon-wrap">
                                <input type="text" name="coupon" class="coupon" value="" placeholder="Coupon code">
                                <div class="alert alert-success" role="alert">
                                    <strong><?php esc_attr_e('Well done!','touroperatorpro') ?></strong><?php esc_attr_e('You have successfully added coupon !!!','touroperatorpro') ?>
                                </div>
                                <input type="button" class="counpon" name="apply_coupon" value="<?php esc_attr_e('APPLY COUPON','touroperatorpro'); ?>">
                            </div>
                            <div class=" form-group clearfix button-wrapper">
                                <button class="btn btn-info book-now"><?php esc_attr_e('Book now','touroperatorpro'); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
<?php } else { ?>
    <div class="row">
        <div class="col-md-12">
            <div id="notfound">
                <div class="notfound">
                    <div class="notfound-404">
                        <h1><?php esc_attr_e('OOPS','touroperatorpro') ?></h1>
                    </div>
                    <h2>404 - <?php esc_attr_e('Page not found','touroperatorpro') ?></h2>
                    <p><?php esc_attr_e('The page you are looking for might have been removed had its name changed or is temporarily unavailable','touroperatorpro') ?></p>
                    <a href="<?php echo ($page_list_tour_search_result) ?>"><?php esc_attr_e('Go to tour list page','touroperatorpro') ?></a>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php
$doc->addScriptApplySelector('.view-tour-detail', 'view_tour_detail', array(
    'tour' => $this->tour,
    'group_size' => isset($this->tour->group_size) ? (int)$this->tour->group_size : 0,
    'discount_amount' => isset($this->tour->discount->amount) ? CurrencyHelper::convertCurrencyFront((int)$this->tour->discount->amount): 0,
    'discount_percent' => isset($this->tour->discount->percent) ? CurrencyHelper::convertCurrencyFront((int)$this->tour->discount->percent): 0,
    'adult' => array(
        'min' => 1,
        'max' => 10,
        'current' => 1,
        'price' => isset($this->tour->adult_price) ? CurrencyHelper::convertCurrencyFront((float)$this->tour->adult_price) : 0
    ),
    'children' => array(
        'min' => 0,
        'max' => 10,
        'current' => 0,
        'price' => isset($this->tour->children_price) ? CurrencyHelper::convertCurrencyFront((float)$this->tour->children_price) : 0
    ),
    'infant' => array(
        'min' => 0,
        'max' => 10,
        'current' => 0,
        'price' => isset($this->tour->infant_price) ? CurrencyHelper::convertCurrencyFront((float)$this->tour->infant_price) : 0
    ),
    'format_currency' =>$format_currency,
), "frontend/app/assets/js/view_tour_detail.js");
?>

