<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\TourOperatorProHtmlFrontend;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\CurrencyHelper;
use TourOperatorProFrontend\app\helpers\FrontendHelper;
use TourOperatorProFrontend\app\Html\HtmlFrontend;

$doc= FactoryAlias::getDocument();
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addLessStyleSheet("frontend/app/assets/less/view-thanks-checkout.less");
TourOperatorProHtmlFrontend::load_jquery_library('fontawesome');
$order = $this->order;
$amount = 0;
$percent = 0;
$coupon = 0;
if(!empty((array)$order->tour->discount)) {
    $discount = $order->tour->discount;
    if(isset($discount->amount) && $discount->amount > 0) {
        $amount = $discount->amount;
    } else if (isset($discount->percent) && $discount->percent > 0) {
        $percent = $discount->percent;
    }
}if(!empty($order->coupon)) {
    $coupon = $order->coupon;
    if(isset($coupon->amount) && $coupon->amount > 0) {
        $coupon_amount = $coupon->amount;
    } else if (isset($coupon->percent) && $coupon->percent > 0) {
        $coupon_percent = $coupon->percent;
    }
}
$total=$order->list_order_detail[0]->total;
if($amount > 0) {
    $total= $total - $amount;
} else if ($percent > 0) {
    $total = $total *  (1 - $percent / 100);
}
?>

<div class="view-booking-thank">
    <div class="row">
        <div class="col-sm-7 col-md-8">
            <div class="wrapper-greeting-thank">
                <div class="submit-done">
                    <span>
                        <i class="far fa-check-circle"></i>
                    </span>
                </div>
                <div class="greeting-thank">
                    <?php foreach ($order->customer as $item){?>
                    <div class="greeting-thank-top">
                        <span class="customer-firstname"><?php Text::_echo_no_translate($item->first_name);?></span>,
                        <span><?php esc_attr_e('Your order was submitted successfully','touroperatorpro')?></span>
                    </div>
                    <div class="greeting-thank-bottom">
                        <span><?php esc_attr_e('Booking details has been sent to','touroperatorpro')?></span>
                        <span class="customer-email"><?php Text::_echo_no_translate($item->email);?></span>
                    </div>
                    <?php }?>

                </div>
            </div>
        </div>
        <div class="col-sm-5 col-md-4">
            <div class="wrapper-booking-info">
                <div class="booking-info-item">
                    <span class="info-item-title"><?php esc_attr_e('Booking number','touroperatorpro')?>:</span>
                    <span class="info-item-content"><?php Text::_echo_no_translate($order->id);?></span>
                </div>
                <div class="booking-info-item">
                    <?php foreach ($order->list_order_detail as $item) ?>
                    <span class="info-item-title"><?php esc_attr_e('Booking date','touroperatorpro')?>:</span>
                    <span class="info-item-content"><?php Text::_echo_no_translate(HtmlFrontend::render_date($item->start_date));?></span>

                </div>
                <div class="booking-info-item">
                    <span class="info-item-title"><?php esc_attr_e('Payment method','touroperatorpro')?>:</span>
                    <span class="info-item-content"><?php esc_attr_e('Bank transfer','touroperatorpro');?></span>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-8">
            <div class="wrapper-your-infomation">
                <?php foreach ($order->customer as $item){?>
                <h4><?php esc_attr_e('Your information','touroperatorpro')?></h4>
                <div class="table-information">
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('First name','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->first_name)?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('Last name','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->last_name);?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('Email','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->email);?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('Address','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->address_1);?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('Address','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->address_2);?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('City','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->city);?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('State/province/region','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->state);?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('Zip_code/postal_code','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->zip_code);?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('Country','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->countryname);?></span>
                    </div>
                    <div class="tr-information-item">
                        <span><?php esc_attr_e('Special requirements','touroperatorpro')?></span>
                        <span><?php esc_html_e($item->note_internal);?></span>
                    </div>
                </div>
                <?php }?>
            </div>
        </div>
        <div class="col-md-4">
            <div class="wrapper-your-item">
                <h4><?php esc_attr_e('Your item','touroperatorpro')?></h4>
                <div class="block-your-item">
                    <div class="block-info-tour">
                        <div class="block-info-tour-left">
                            <span class="tour-name"><?php esc_html_e($order->tour->name);?></span>
                            <span class="destination">
                                <i class="icon-nb-pin"></i>
                                 <?php foreach ($order->tour->destination as $item) {?>
                                <span><?php esc_html_e($item->address);?></span>
                                 <?php } ?>
                            </span>

                        </div>
                        <div class="block-info-tour-right">
                            <div>
                                <img src="<?php echo(FactoryAlias::getRootUrlPlugin());?><?php Text::_echo_no_translate($order->tour->image);?>" >
                            </div>
                        </div>
                    </div>
                    <div class="block-info-tour-booking">
                        <?php foreach ($order->list_order_detail as $order_detail) ?>
                        <div class="block-info-tour-booking-item">
                            <span><?php esc_attr_e('Max people','touroperatorpro')?></span>
                            <span><?php Text::_echo_no_translate($order->tour->group_size);?></span>
                        </div>
                        <div class="block-info-tour-booking-item">
                            <span><?php esc_attr_e('No adult','touroperatorpro')?></span>
                            <span><?php esc_html_e($order_detail->adult);?></span>
                        </div>
                        <div class="block-info-tour-booking-item">
                            <span><?php esc_attr_e('No children','touroperatorpro')?></span>
                            <span><?php esc_html_e($order_detail->children);?></span>
                        </div>
                        <div class="block-info-tour-booking-item">
                            <span><?php esc_attr_e('No infant','touroperatorpro')?></span>
                            <span><?php esc_html_e($order_detail->infant);?></span>
                        </div>
                        <div class="block-info-tour-booking-item">
                            <span><?php esc_attr_e('Date','touroperatorpro')?></span>
                            <span><?php esc_html_e(HtmlFrontend::render_date($order_detail->start_date));?></span>
                        </div>
                        <div class="block-info-tour-booking-item">
                            <span><?php esc_attr_e('Duration','touroperatorpro')?></span>
                            <span><?php esc_html_e($order->tour->duration);?></span>
                        </div>

                    </div>
                    <div class="block-info-tour-price">
                        <?php foreach ($order->list_order_detail as $order_detail) {?>
                        <div class="block-info-tour-price-item">
                            <span><?php esc_attr_e('Adult price','touroperatorpro')?></span>
                            <span><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)($order->tour->adult_price * $order_detail->adult))));?></span>
                        </div>
                        <div class="block-info-tour-price-item">
                            <span><?php esc_attr_e('Children price','touroperatorpro')?></span>
                            <span><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)($order->tour->children_price * $order_detail->children))));?></span>
                        </div>
                        <div class="block-info-tour-price-item">
                            <span><?php esc_attr_e('Infant price','touroperatorpro')?></span>
                            <span><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)($order->tour->infant_price * $order_detail->infant))));?></span>
                        </div>
                        <div class="block-info-tour-price-item">
                            <span><?php esc_attr_e('Discount','touroperatorpro')?></span>
                            <?php if($amount > 0) {?>
                                <span><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront($amount)))?></span>
                            <?php } else if ($percent > 0) {?>
                                <span><?php esc_html_e($percent)?>%</span>
                            <?php } else if ($amount == 0 && $percent==0) {?>
                                <span><?php esc_html_e($percent)?></span>
                            <?php }?>
                        </div>
                        <?php } ?>
                        <div class="block-info-tour-price-item">
                            <span><?php esc_attr_e('Coupon','touroperatorpro')?></span>
                            <?php if (isset($coupon_amount) && $coupon_amount != null){ ?>
                        <?php if($coupon_amount > 0) {?>
                        <span><?php  esc_attr_e(' - ','touroperatorpro')?><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront($coupon_amount)))?></span>
                        <?php } else if ($coupon_percent > 0) {?>
                        <span><?php esc_html_e($coupon_percent)?>%</span>
                        <?php } else if ($coupon_amount == 0 && $coupon_percent==0) {?>
                        <span><?php esc_html_e($coupon_percent)?></span>
                        <?php }?>
                            <?php }?>

                    </div>
                        <div class="block-info-tour-price-item">
                            <span><?php esc_attr_e('Subtotal','touroperatorpro')?></span>
                            <span><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$total)));?></span>
                        </div>
                        <div class="block-info-tour-price-item payment-amount">
                            <span><?php esc_attr_e('Pay amount','touroperatorpro')?></span>
                            <span><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$total)));?></span>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
