<?php


use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\TourOperatorProHtmlFrontend;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use TourOperatorProFrontend\app\helpers\CurrencyHelper;
use TourOperatorProFrontend\app\helpers\FrontendHelper;
use TourOperatorProFrontend\app\Html\HtmlFrontend;

$doc = FactoryAlias::getDocument();
TourOperatorProHtmlFrontend::load_jquery_library('confirm');
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-checkout.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$page_checkout = ConfigHelperAlias::get_page_tour_checkout();
$post_content=get_post($page_checkout);
if($page_checkout && $post_content)
    $this->page_checkout = get_page_link($page_checkout);
else{
    $this->page_checkout="";
}
$number_tour = count((array)$this->tour);
$page_list_tour_search_result = ConfigHelperAlias::get_page_list_tour_search_result();
$post_content=get_post($page_list_tour_search_result);
if($page_list_tour_search_result && $post_content)
{
    $page_list_tour_search_result = get_page_link($page_list_tour_search_result);
}else{
    $page_list_tour_search_result="";
}
?>
<?php
    if ($number_tour==0){?>
        <div class="not_found">
            <div class="notfound-404">
                <h1> <?php esc_attr_e("OOPS!",'touroperatorpro') ?></h1>
            </div>
            <h2>404 - <?php esc_attr_e("Tour not found",'touroperatorpro') ?></h2>
            <p><?php esc_attr_e("The page you are looking for might have been removed had its name changed or is temporarily unavailable",'touroperatorpro') ?></p>
            <a href="<?php echo ($page_list_tour_search_result)?>"><?php esc_attr_e("Go to tour list page",'touroperatorpro') ?></a>
        </div>
    <?php }else {?>
        <div class="view-checkout-default checkout">
            <form action="<?php echo ($this->page_checkout) ?>" method="post">
                <div class="row">
                    <div class="col-md-8">
                        <h3 class="title" style="color: red"><?php esc_attr_e('Booking submission','touroperatorpro');?></h3>
                        <div class="check-out-form">
                            <div class="entry-content"></div>
                            <div class="cc-form">
                                <div class="clearfix">
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6">
                                            <?php echo ($this->form->renderField('first_name')) ?>
                                        </div>
                                        <div class="col-sm-6 col-md-6">
                                            <?php echo ($this->form->renderField('last_name')) ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6">
                                            <?php echo ($this->form->renderField('email')) ?>
                                        </div>
                                        <div class="col-sm-6 col-md-6 phone">
                                            <?php echo ($this->form->renderField('mobile')) ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6 ">
                                            <?php echo ($this->form->renderField('address_line1')) ?>
                                        </div>
                                        <div class="col-sm-6 col-md-6">
                                            <?php echo ($this->form->renderField('address_line2')) ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6">
                                            <?php echo ($this->form->renderField('city')) ?>
                                        </div>
                                        <div class="col-sm-6 col-md-6">
                                            <?php echo ($this->form->renderField('province')) ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6">
                                            <?php echo ($this->form->renderField('zip_code')) ?>
                                        </div>
                                        <div class="col-sm-6 col-md-6">
                                            <?php echo ($this->form->renderField('country')) ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <?php echo ($this->form->renderField('description')) ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="payment-form">
                                    <h4 class="title"><?php esc_attr_e('Select payment method','touroperatorpro');?></h4>
                                    <div class="dropdown">
                                        <lable>
                                            <div class="check-payment">
                                                <input type="radio" class="payment-item-radio">
                                            </div>
                                            <span class="title-payment">
                                <?php esc_attr_e('Bank transfer','touroperatorpro');?>
                            </span>
                                            <img src="<?php Text::_echo_no_translate(FactoryAlias::getRootUrlPlugin()); ?>frontend/app/assets/image/nm-logo.png"
                                                 alt="" class="st_submit_form">
                                        </lable>
                                        <div class="dropdown_menu">
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <div class="col-card-info">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="cond-form">
                                    <div class="st-icheck">
                                        <div class="st-icheck-item">
                                            <lable>
                                                <span class="checkmark">
                                                    <input type="checkbox">
                                                </span>
                                                <span class="title-payment">
                                                    <?php esc_attr_e('I have read and accept the','touroperatorpro');?>
                                                    <a href=""><?php esc_attr_e('Terms and conditions','touroperatorpro');?></a>
                                                    <?php esc_attr_e('And','touroperatorpro');?>
                                                    <a href=""><?php esc_attr_e('Privacy policy','touroperatorpro');?></a>
                                                </span>
                                            </lable>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix">
                                    <button href="" class="btn btn-primary btn-checkout btn-st-checkout-submit"><?php esc_attr_e('Submit','touroperatorpro');?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <h3 class="title"><?php
                            esc_attr_e('Your booking','touroperatorpro');
                            ?>
                        </h3>
                        <div class="cart-info" id="cart-info">
                            <div class="service-section">
                                <div class="service-left">
                                    <h4 class="title">
                                        <?php Text::_echo_no_translate($this->tour->name); ?>
                                    </h4>
                                    <p class="address">
                                        <?php
                                        if (!empty($this->tour->destination)) {
                                            Text::_echo_no_translate( end($this->tour->destination)->address);
                                        }
                                        ?>
                                    </p>
                                </div>
                                <div class="service-right">
                                    <div>
                                        <img src="<?php echo (FactoryAlias::getRootUrlPlugin()); ?><?php echo ($this->tour->image); ?>" >
                                    </div>
                                </div>
                            </div>
                            <div class="info-section">
                                <ul>
                                    <li>
                                        <span class="label">
                                            <?php esc_attr_e('Tour type','touroperatorpro');?>
                                        </span>
                                        <span class="value">
                                            <?php echo (
                                                implode(',', array_map(function ($u){
                                                    return $u->name;
                                                }, $this->tour->tourtype))
                                            ); ?>
                                        </span>
                                    </li>
                                    <li>
                                <span class="label">
                                    <?php esc_attr_e('Departure date','touroperatorpro');?>
                                </span>
                                        <span class="value">
                                    <?php
                                        echo (HtmlFrontend::render_date($this->date_check_in));
                                    ?>
                                </span>
                                    </li>
                                    <li>
                                <span class="label">
                                    <?php esc_attr_e('Duration','touroperatorpro');?>
                                </span>
                                        <span class="value">
                                    <?php
                                    echo ($this->tour->duration." ");
                                    if($this->tour->duration <2){
                                        echo ('Day');
                                    }else {
                                        echo ('Days');
                                    }
                                    ?>
                                </span>
                                    </li>
                                </ul>
                            </div>
                            <div class="ad-info">
                                <ul>
                                    <li>
                                <span class="label">
                                    <?php esc_attr_e('Number of adult','touroperatorpro');?>
                                </span>
                                        <span class="value">
                                    <?php
                                    echo ($this->number_adult);
                                    ?>
                                </span>
                                    </li>
                                    <li>
                                <span class="label">
                                     <?php esc_attr_e('Number of children','touroperatorpro');?>
                                </span>
                                        <span class="value">
                                     <?php
                                     echo ($this->number_children);
                                     ?>
                                </span>
                                    </li>
                                    <li>
                                <span class="label">
                                     <?php esc_attr_e('Number of infant','touroperatorpro');?>
                                </span>
                                        <span class="value">
                                     <?php
                                         echo ($this->infant_number);
                                     ?>
                                </span>
                                    </li>
                                </ul>
                            </div>
                            <div class="total-section">
                                <ul>
                                    <li>
                        <span class="label">
                            <?php esc_attr_e('Adult price','touroperatorpro');?>
                        </span>
                                        <span class="value">
                            <?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$this->tour->adult_price * $this->number_adult))); ?>

                        </span>
                                    </li>
                                    <li>
                        <span class="label">
                            <?php esc_attr_e('Children price','touroperatorpro');?>
                        </span>
                                        <span class="value">
                            <?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$this->tour->children_price * $this->number_children))); ?>
                        </span>
                                    </li>
                                    <li>
                        <span class="label">
                           <?php esc_attr_e('Infant price','touroperatorpro');?>
                        </span>
                                        <span class="value">
                            <?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$this->tour->infant_price * $this->infant_number))); ?>
                        </span>
                                    </li>
                                    <li>
                        <span class="label">
                            <?php esc_attr_e('Discount','touroperatorpro');?>
                        </span><span class="value">
                            <?php
                            if($this->tour->discount) {
                                if ($this->tour->discount->amount > 0) {
                                    echo ('-' . esc_html_e(CurrencyHelper::convertCurrencyFront($this->tour->discount->amount)));
                                } else if ($this->tour->discount->percent > 0) {
                                    echo ($this->tour->discount->percent . '%');
                                }else {
                                    echo ('0');
                                }
                            }else{
                                echo ('0');
                            }
                            ?>
                        </span>
                                    </li>
                                    <li>
                            <span class="label">
                            <?php esc_attr_e('Coupon','touroperatorpro');?>
                            </span>
                                        <span class="value">
                                            <?php
                                            foreach ($this->tour->coupon as $item) {
                                                if (in_array($this->coupons, (array)$item)) {
                                                    if ($item->amount) {
                                                        if ($item->amount > 0) {
                                                            if ($this->coupons == $item->code ) {
                                                               esc_attr_e(' - ','touroperatorpro')?><?php echo (CurrencyHelper::convertCurrencyFront($item->amount));
                                                            }
                                                        } else if ($item->percent > 0) {
                                                            if ($this->coupons == $item->code ) {
                                                            echo($item->percent . '%');
                                                            }
                                                        } else {
                                                            echo('0');
                                                        }
                                                    } else {
                                                        echo('0');
                                                    }
                                                }
                                            }

                                            ?>
                                        </span>
                                    </li>
                                    <li>
                        <span class="label">
                            <?php esc_attr_e('Subtotal','touroperatorpro');?>
                        </span>
                        <span class="value">
                            <?php
                            if($this->tour->discount) {
                                if ($this->tour->discount->amount>0){
                                    $subtotal=(($this->tour->adult_price * $this->number_adult + $this->tour->children_price * $this->number_children + $this->tour->infant_price * $this->infant_number)-$this->tour->discount->amount);
                                }elseif ($this->tour->discount->percent>0) {
                                    $subtotal=(($this->tour->adult_price * $this->number_adult + $this->tour->children_price * $this->number_children + $this->tour->infant_price * $this->infant_number) * (1 - $this->tour->discount->percent / 100));
                                }
                                else{
                                    $subtotal =($this->tour->adult_price * $this->number_adult + $this->tour->children_price * $this->number_children + $this->tour->infant_price * $this->infant_number);
                                }
                            }else {
                                $subtotal =($this->tour->adult_price * $this->number_adult + $this->tour->children_price * $this->number_children + $this->tour->infant_price * $this->infant_number);
                            }
                            foreach ($this->tour->coupon as $item) {
                                if ($item->amount) {
                                    if ($item->amount > 0) {
                                        if ($this->coupons == $item->code) {
                                            $subtotal = (($this->tour->adult_price * $this->number_adult + $this->tour->children_price * $this->number_children + $this->tour->infant_price * $this->infant_number) - $item->amount);
                                        }
                                    } elseif ($item->percent > 0) {
                                        if ($this->coupons == $item->code) {
                                            $subtotal = (($this->tour->adult_price * $this->number_adult + $this->tour->children_price * $this->number_children + $this->tour->infant_price * $this->infant_number) * (1 - $item->percent / 100));
                                        }
                                    } else {
                                        $subtotal = ($this->tour->adult_price * $this->number_adult + $this->tour->children_price * $this->number_children + $this->tour->infant_price * $this->infant_number);
                                    }
                                } else {
                                    $subtotal = ($this->tour->adult_price * $this->number_adult + $this->tour->children_price * $this->number_children + $this->tour->infant_price * $this->infant_number);
                                }

                            }
                            esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$subtotal)));
                            ?>
                            </span>
                        </li>
                        <li class="payment-amount">
                        <span class="label">
                           <?php esc_attr_e('Pay amount','touroperatorpro');?>
                        </span>
                        <span class="value">
                            <?php echo esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront($subtotal)))?>
                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php  foreach ($this->tour->coupon as $item) {
                        if ($this->coupons == $item->code){?>
                            <input type="hidden" name="coupon_id" value="<?php echo ($item->id) ?>">
                        <?php } ?>
                    <?php } ?>
                    <input type="hidden" name="adult" value="<?php echo ($this->number_adult) ?>">
                    <input type="hidden" name="children" value="<?php echo ($this->number_children) ?>">
                    <input type="hidden" name="infant" value="<?php echo ($this->infant_number) ?>">
                    <input type="hidden" name="tour_id" value="<?php echo ($this->tour->id) ?>">
                    <input type="hidden" name="total" value="<?php echo ($subtotal)?>">
                    <input type="hidden" name="task" value="checkout.booknow">
                </div>
            </form>
        </div>
    <?php } ?>
<?php
$doc->addScriptApplySelector('.view-checkout-default','view_checkout_default',array(
        'tour'=>$this->tour
),"frontend/app/assets/js/view_checkout_default.js");
?>
