<?php
namespace TourOperatorProFrontend\app\views\checkout;

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;

class CheckoutView extends View
{
    public $tour;
    public $number_children;
    public $number_adult;
    public $infant_number;
    public $date_check_in;
    public $first_name;
    public $last_name;
    public function display($tpl){
        $input=FactoryAlias::getInput();
        switch ($tpl){
            case "thanks":
                $order_id = $input->getInt('order_id', 0);
                $modelOrder=Model::getInstance("order");
                $this->order=$modelOrder->getItem($order_id);
                break;
            case "list":
                $model=Model::getInstance("checkout");
                $this->list=$model->getList();
                break;
            default:
                $this->number_children=$input->getInt('children_number','0');
                $this->number_adult=$input->getInt('adult_number',1);
                $this->date_check_in=$input->getString('date_check_in',date("Y/m/d"));
                $this->infant_number=$input->getInt('infant_number','0');
                $this->coupons = $input->getString('coupon','');
                $modelCheckout=Model::getInstance("checkout");
                $id = $input->getInt('tour_id', 0);
                $this->item = $modelCheckout->getItem($id);
                $this->form = $modelCheckout->getForm();
                $modelTour=Model::getInstance("tour");
                $id = $input->getInt('tour_id', 0);
                $this->tour = $modelTour->getItem($id);
                break;
        }
        return parent::display($tpl);
    }


}