<?php
namespace TourOperatorProFrontend\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorProFrontend\app\helpers\FrontendHelper;
use TourOperatorProFrontend\app\Html\HtmlFrontend;

class OrderModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "order";
    /**
     * @var string
     */
    public $table_name = "order";
    public function getItem($id = 0)
    {
        $order= parent::getItem($id); // TODO: Change the autogenerated stub
        $query= $this->_db->getQuery(true);
        $query->clear()
            ->select('customer1.*')
            ->from($this->getTableName("customer")." AS customer1")
            ->leftJoin($this->getTableName('country'). ' AS country ON country.countrycode = customer1.country_code')
            ->select('country.countryname AS country_name')
            ->where('customer1.id='.(int)$order->customer_id)
        ;
        $customer=$this->_db->setQuery($query)->loadObjectList();
        $order->customer= reset($customer);

        $query->clear()
            ->select('order_detail.*')
            ->from($this->getTableName('order_detail').' AS order_detail')
            ->where('order_detail.order_id='.(int)$id)
        ;
        $order_detail=$this->_db->setQuery($query)->loadObjectList();
        $order->order_detail = reset($order_detail);

        $query->clear()
            ->select('tour.*')
            ->from($this->getTableName('tour'). ' AS tour')
            ->where('tour.id='.(int)$order->order_detail->tour_id)
        ;
        $tour=$this->_db->setQuery($query)->loadObjectList();
        foreach ($tour as &$item_tour) {
            $query->clear()
                ->select('DISTINCT tourtype.*')
                ->from($this->getTableName('tourproperty').' AS tourproperty')
                ->leftJoin($this->getTableName('tourtype').' AS tourtype ON tourtype.id=tourproperty.object_id')
                ->where('tour_id='.(int)$item_tour->id)
                ->where('type='.$query->quote(FrontendHelper::getTourTypeKey()))
            ;
            $list_tour_type= $this->_db->setQuery($query)->loadObjectList();
            $item_tour->tourtype=$list_tour_type;

            $query->clear()
                ->select('DISTINCT location.*')
                ->from($this->getTableName('tourproperty').' AS tourproperty')
                ->leftJoin($this->getTableName('location').' AS location ON location.id=tourproperty.object_id')
                ->where('tour_id='.(int)$item_tour->id)
                ->where('type='.$query->quote(FrontendHelper::getTourDestinationKey()))
            ;
            $list_destination= $this->_db->setQuery($query)->loadObjectList();
            $item_tour->destination=$list_destination;

            $query->clear()
                ->select('DISTINCT discount.*')
                ->from($this->getTableName('tourproperty').' AS tourproperty')
                ->leftJoin($this->getTableName('discount').' AS discount ON discount.id=tourproperty.object_id')
                ->where('tour_id='.(int)$item_tour->id)
                ->where('type='.$query->quote(FrontendHelper::getTourDiscountKey()))
            ;
            $list_discount= $this->_db->setQuery($query)->loadObjectList();
            $item_tour->discount= reset($list_discount);

        }
        $order->tour = reset($tour);
        return $order;
    }
}
