<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('dateselect');
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/mediabrowser/mediabrowser.less');
$id_by_name = "element_field_". $name;
$name_of_field = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-mediabrowser-<?php esc_attr_e($name_of_field) ?>">
        <div class="show-image"><img class="media-show" src="<?php echo($value) ?>"></div>
        <div class="input-group">
            <input name="<?php esc_attr_e($name); ?>" value="<?php esc_attr_e($value) ?>" type="text"
                   class="form-control" >
            <span class="input-group-btn">
        <button class="btn btn-default btn-browser-media" type="button"><?php esc_attr_e('Browser','touroperatorpro') ?></button>
      </span>
        </div><!-- /input-group -->
    </div>
<?php
$doc->addScriptApplySelector('.field-mediabrowser-'.$name_of_field,'field_mediabrowser',array(
    "input_name"=>  $name,
    "multiple"=>  $multiple,
),'admin/app/layouts/WooBooking/form/field/mediabrowser/mediabrowser.jquery.js');
