<?php
use TourOperatorPro\Factory;
use TourOperatorPro\Html\TourOperatorProHtmlFrontend;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;

defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_". $name;
$name_format = str_replace(array('[', ']'), '_', $name);
$locationsModel = Model::getInstance('destinations');
$list_location = $locationsModel->getList();
$list_selected = is_array($value) ? $value : array();


?>
    <div id="<?php esc_attr_e($id_by_name) ?>"
         class="<?php esc_attr_e($class); ?> field-locations-<?php esc_attr_e($name_format) ?> field-locations">
        <select name="<?php esc_attr_e($name); ?>" <?php echo ($multiple ? ' multiple ' : null); ?>
                class="form-control list-locations">
            <option value=""><?php esc_attr_e('Select location','touroperatorpro')?></option>
			<?php foreach ($list_location as $location) { ?>
                <option <?php echo (in_array($location->id, $list_selected) ? " selected " : "") ?>
                        value="<?php esc_attr_e($location->id); ?>"><?php esc_html_e($location->address); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
TourOperatorProHtmlFrontend::load_jquery_library('select2');
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/locations/locations.less');
$doc->addScriptApplySelector('.field-locations','field_locations',array(
    "field_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/locations/locations.jquery.js');
