<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlFrontend as TourOperatorProHtmlFrontend;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlFrontend::load_jquery_library('select2');
TourOperatorProHtmlFrontend::load_jquery_library('icheck');
TourOperatorProHtmlFrontend::load_jquery_library('twbs_pagination');
TourOperatorProHtmlFrontend::load_jquery_library('cookie_js');
TourOperatorProHtmlFrontend::load_jquery_library('confirm');
TourOperatorProHtmlFrontend::load_jquery_library('icheck');
TourOperatorProHtmlFrontend::load_jquery_library('select2');
TourOperatorProHtmlFrontend::load_jquery_library('loading_js');
TourOperatorProHtmlFrontend::load_jquery_library('datatables');
$id_by_name = "element_field_". $name;
$modelCurrencies=Model::getInstance('currencies');
$this->listCurrencies = $modelCurrencies->getList();
$appConfig = Factory::getAppConfig();
$symbol = $appConfig->get('currencies_in_list', '');
$currencyModel = Model::getInstance('currency');
if (isset($_SESSION["currency"])){
    $currency = $_SESSION["currency"];
    $this->symbol = $currencyModel->format_currency($currency);
}else{
    $this->symbol = $currencyModel->format_currency($symbol);
}

?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field_change_symols">
        <meta http-equiv="cache-control" content="no-cache" />
        <meta http-equiv="Pragma" content="no-cache" />
        <form class="form-inline">
            <div class="input-group mb-2 mr-sm-2 mb-sm-0">
                <div class="input-group-addon currency-symbol">
                    <?php echo isset($this->symbol) && $this->symbol != '' ?  reset($this->symbol): esc_attr_e('$', 'touroperatorpro') ?>
                </div>
                <div class="input-group-addon currency-addon">
                    <select class="currency-selector">
                        <?php foreach ($this->listCurrencies as $listCurrencies){ ?>
                            <option <?php echo (in_array(reset($this->symbol),(array)$listCurrencies) ? ' selected ' : '')?> data-symbol="<?php echo (in_array(reset($this->symbol),(array)$listCurrencies) ? reset($this->symbol) : $listCurrencies->symbol) ?>"><?php  echo (in_array(reset($this->symbol),(array)$listCurrencies)?$listCurrencies->code:$listCurrencies->code )?></option>
                        <?php } ?>
                    </select>

                </div>
            </div>
        </form>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/changecurrency/changecurrency.less');
$doc->addScriptApplySelector('.field_change_symols','field_change_symols',array(
),'frontend/app/layouts/WooBooking/form/field/changecurrency/changecurrency.js');