<?php
namespace TourOperatorProFrontend\app\helpers;

class FrontendHelper
{
    public static $list_key_tour_properties=array(
        'destination'=>"destination",
        'tourtype'=>'tourtype',
        'activity'=>'activity',
        'discount'=>'discount',
        'coupon'=>'coupon',
        'rate'=>'rate',
    );
    public static function getTourDestinationKey(){
        return self::$list_key_tour_properties['destination'];
    }
    public static function getCountryNameKey(){
        return self::$list_key_tour_properties['countryname'];
    }
    public static function format_currency($cost = 0, $currency = "$")
    {
        return "$currency $cost";
    }
    public static function getTourTypeKey(){
        return self::$list_key_tour_properties['tourtype'];
    }
    public static function getTourActivityKey(){
        return self::$list_key_tour_properties['activity'];
    }
    public static function getTourDiscountKey(){
        return self::$list_key_tour_properties['discount'];
    }
    public static function getTourCouponKey(){
        return self::$list_key_tour_properties['coupon'];
    }
    public static function getTourRateKey(){
        return self::$list_key_tour_properties['rate'];
    }
    public static function getListKeyOfTourProperties(){
        return static::$list_key_tour_properties;
    }
    public static function getDateOfWeekDayInMonth($date_start, $date_end, $day_of_week=array()) {
        $date_recurring = array();
        if(!empty($day_of_week)) {
            foreach ($day_of_week as $day) {
                switch ($day) {
                    case "monday":
                        $date_recurring["monday"] = self::getDayOfWeekInRange($date_start, $date_end, 'monday');
                        break;
                    case "tuesday":
                        $date_recurring["tuesday"] = self::getDayOfWeekInRange($date_start, $date_end, 'tuesday');
                        break;
                    case "wednesday":
                        $date_recurring["wednesday"] = self::getDayOfWeekInRange($date_start, $date_end, 'wednesday');
                        break;
                    case "thursday":
                        $date_recurring["thursday"] = self::getDayOfWeekInRange($date_start, $date_end, 'thursday');
                        break;
                    case "friday":
                        $date_recurring["friday"] = self::getDayOfWeekInRange($date_start, $date_end, 'friday');
                        break;
                    case "saturday":
                        $date_recurring["saturday"] = self::getDayOfWeekInRange($date_start, $date_end, 'saturday');
                        break;
                    case "sunday":
                        $date_recurring["sunday"] = self::getDayOfWeekInRange($date_start, $date_end, 'sunday');
                        break;
                }
            }
        } else {
            return $date_recurring;
        }
        return  $date_recurring;

    }
    public static function getDayOfWeekInRange($dateFromString, $dateToString, $day='')
    {
        $dateFrom = new \DateTime($dateFromString);
        $dateTo = new \DateTime($dateToString);
        $dates = [];
        if(strtolower(date('l',strtotime($dateFromString))) == $day) {
            $dates[] = $dateFromString;
        }


        if ($dateFrom > $dateTo) {
            return $dates;
        }

        if (1 != $dateFrom->format('W')) {
            $dateFrom->modify('next '.$day);
        }

        while ($dateFrom <= $dateTo) {
            $dates[] = $dateFrom->format('Y-m-d');
            $dateFrom->modify('+1 week');
        }

        return $dates;
    }

}