<?php
namespace TourOperatorProFrontend\app\helpers;

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Mvc\Model\Model;

class CurrencyHelper extends FrontendHelper
{
    public static function convertCurrencyFront($amount = 0)
    {
        $appConfig = FactoryAlias::getAppConfig();
        $from = $appConfig->get('currencies_in_list', '');
        isset($_SESSION["currency"])?$currency_converter = $_SESSION["currency"]:$currency_converter = "";
        if ($currency_converter == "" && empty($currency_converter)) {
            if ($from == "EUR"){
                $from = 1.0;
                $rate = $from / $from;
                $result = round($amount * $rate);
                return $result;
            }
            $url = 'https://api.exchangeratesapi.io/latest?base=' . $from . '&symbols=' . $from . ',' . $from . '';
            $response_json = file_get_contents($url);
            $exchangeRates = json_decode($response_json, true);
            if ($exchangeRates) {
                if (!empty($exchangeRates['rates'] && $exchangeRates['rates'] != '')) {
                    $from = $exchangeRates['rates'][$from];
                    $rate = $from / $from;
                    $result = round($amount * $rate);
                    return $result;
                }
            }
        }else{
            if ($from == $currency_converter){
                $from = 1.0;
                $rate = $from / $from;
                $result = round($amount * $rate);
                return $result;
            }
            if ($from == "EUR"){
                $url = "https://api.exchangeratesapi.io/latest?symbols=".$currency_converter;
                $from = 1.0;
                $response_json = file_get_contents($url);
                $exchangeRates = json_decode($response_json, true);
                if ($exchangeRates) {
                    if (!empty($exchangeRates['rates'] && $exchangeRates['rates'] != '')) {
                        $to = $exchangeRates['rates'][$currency_converter];
                        $rate = $to / $from;
                        $result = round($amount * $rate);
                        return $result;
                    }
                }
            }
            $url = 'https://api.exchangeratesapi.io/latest?base=' . $from . '&symbols=' . $from . ',' . $currency_converter . '';
            $response_json = file_get_contents($url);
            $exchangeRates = json_decode($response_json, true);
            if ($exchangeRates) {
                if (!empty($exchangeRates['rates'] && $exchangeRates['rates'] != '')) {
                    $from = $exchangeRates['rates'][$from];
                    $to = $exchangeRates['rates'][$currency_converter];
                    $rate = $to / $from;
                    $result = round($amount * $rate);
                    return $result;
                }
            }
        }
    }
    public static function convertSymbols($cost = 0){
        $appConfig = FactoryAlias::getAppConfig();
        $symbol = $appConfig->get('currencies_in_list', '');
        isset($_SESSION["symbol"])?$convert_symbol = $_SESSION["symbol"]:$convert_symbol = "";
        $currencyModel = Model::getInstance('currency');
        $symbol = $currencyModel->format_currency($symbol);
        $currency = reset($symbol);
        if ($convert_symbol == "" && empty($convert_symbol)){
            if($currency)
            {
                return "$currency $cost";
            }
        }else{
            return "$convert_symbol $cost";
        }
    }
    public static function format_currency_frontend()
    {
        $appConfig = FactoryAlias::getAppConfig();
        $symbol = $appConfig->get('currencies_in_list', '');
        isset($_SESSION["symbol"])?$convert_symbol = $_SESSION["symbol"]:$convert_symbol = "";
        $currencyModel = Model::getInstance('currency');
        $symbol = $currencyModel->format_currency($symbol);
        $currency = reset($symbol);
        if ($convert_symbol == "" && empty($convert_symbol)){
            if($currency)
            {
                return "$currency";
            }
        }else{
            return "$convert_symbol";
        }
    }

}