<?php

namespace TourOperatorProFrontend\app\controllers;

use TourOperatorPro\Factory;
use TourOperatorPro\Filesystem\Support\StringController;
use TourOperatorPro\Mvc\Controller\ControllerFrontend;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorProFrontend\app\helpers\ConfigHelper;
use TourOperatorProFrontend\app\helpers\EmailHelper;
use TourOperatorProFrontend\app\Html\HtmlFrontend;
use TourOperatorProFrontend\app\helpers\FrontendHelper;
defined('_TOUROPERATOR_EXEC') or die;
class ToursController extends ControllerFrontend {

    public function ajax_get_list_tour()
    {
        $input = Factory::getInput();
        $data = $input->getData();
        $user_id = $data['user_id'];
        foreach ($data as $key => $value) {
            if(is_array($value) && count($value) == 1) {
                $input->set($key, $value[0]);
            } else if(is_array($value) && count($value) > 1) {
                $input->set($key, $value);
            }
        };
        $modelTours=Model::getInstance('tours');
        $list=$modelTours->get_list_tour_loc();
        $data = $input->getData();
        $user_id = $data['user_id'];
        foreach ($list as $item){
            $new_price = $item->price;
            if($item->discount) {
                if($item->discount->amount > 0) {
                    $new_price = $item->price - $item->discount->amount;
                } else if ($item->discount->percent > 0) {
                    $new_price= $item->price - ($item->price * $item->discount->percent) / 100 ;
                }
            }
            $item->link= Factory::getRootUrl()."/tour-detail/".$item->alias.'-'.$item->id;
            $item->lng=$item->lang;
            $item->decs= (mb_strimwidth($item->description, 0, 100, "..."));
            $item->img=Factory::getRootUrlPlugin().$item->image ;
            $item->user_wishlist = $item->user_wishlist;
            $item->tour_id = $item->id;                        
            $item->check = in_array($user_id,$item->user_wishlist)?true:false;
            if( intval($item->duration) > 0 ) {
                $item->duration = esc_html($item->duration) . esc_attr__( ' Days ', 'torhub' ) . esc_html((int) $item->duration - 1) . esc_attr__( ' Nights', 'torhub' );
            }else {
                $item->duration = "";
            }
            if (isset(end($item->list_destination)->name)) {
                $item->destination = esc_html(end($item->list_destination)->name);
            }else {
                $item->destination = "";
            }
            $item->description = esc_html( wp_trim_words($item->description, 10, '') );
            if ($item->discount) {
                $item->fare = esc_html((FrontendHelper::format_currency(number_format((float) $item->price, 0))));
            }else {
                $item->fare = esc_html((FrontendHelper::format_currency(number_format((float) $new_price, 0))));
            }
            if ($item->discount) {
                if ($item->discount->amount > 0) {
                    $item->box_sale = esc_html($item->discount->amount);
                }elseif ($item->discount->percent > 0) {
                    $item->box_sale = esc_html($item->discount->percent);
                }
            }
            $item->user_wishlist = $item->user_wishlist;
            $item->check = in_array($user_id,$item->user_wishlist)?true:false;
        }
        echo json_encode($list);
        die;
    }

    public function get_list_tours_ajax_form() {
        $input = Factory::getInput();
        $data = $input->getData();
        $dataForms = json_decode( $data['dataObj'] );
        $dataFormsS = array();
        foreach ($dataForms as $key => $dataForm) {
            if( is_array( $dataForm ) ) {
                if( count($dataForm) == 1 ) {
                    if($key == 'tour_type[]') {
                        $dataFormsS["tour_type"] = $dataForm;
                    }else{
                        $dataFormsS[$key] = $dataForm['0'];
                    }
                }else {
                    if($key == 'tour_type[]') {
                        $dataFormsS["tour_type"] = $dataForm;
                    }else{
                        $dataFormsS[$key] = $dataForm;
                    }
                    
                }
            }
        }
        foreach( $dataFormsS as $name => $value ) {
            $input->set($name,$value);
        }
        $modelTours = Model::getInstance("tours");
        return $view_list_tours = $modelTours->getListToursAjax();
    }
}