<?php

namespace TourOperatorProFrontend\app\controllers;

use Google_Client;
use Google_Service_Calendar;
use TourOperatorPro\Factory;
use TourOperatorPro\Filesystem\Support\StringController;
use TourOperatorPro\Mvc\Controller\ControllerFrontend;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorProFrontend\app\helpers\ConfigHelper;
use TourOperatorProFrontend\app\helpers\EmailHelper;

defined('_TOUROPERATOR_EXEC') or die;

/**
 * Class BlockController
 */
class CheckoutController extends ControllerFrontend
{
    public function booknow()
    {
        $root_url = Factory::getUri()->toString();
        $input = Factory::getInput();
        $appConfig = Factory::getAppConfig();
        $data = $input->getData();
        $is_enable_send_sms = $appConfig->get('is_enable_send_sms','');
        $is_enable_add_google_calendar_api = $appConfig->get('is_enable_add_google_calendar_api','');
        $client_secret_file = $appConfig->get('client_secret_file','');
        $modelCheckout = Model::getInstance('checkout');
        $order = $modelCheckout->checkout_model($data);
   /*     if ($is_enable_send_sms ==1){
            $modelCheckout->send_sms_after_booking($order->id);
        }*/

/*        if ($is_enable_add_google_calendar_api == 1){
            if($client_secret_file !== '' && file_exists(TOUROPERATORPRO_PATH_ROOT.DS.$client_secret_file)) {
                $modelCheckout->add_google_calendar($order->id);
            }
        }*/
        header("Location: $root_url/?view=checkout-thanks&order_id=" . $order->id);
        die;
    }

    public function check_coupon()
    {
        $input = Factory::getInput();
        $code = $input->getString('code', "");
        $tour_id = $input->getString('tour_id', 0);
        $couponModel = Model::getInstance('coupon');
        $coupon = $couponModel->getItemByCode($code,$tour_id);
        return $coupon;
    }

    function verify_google_calendar(){
        $client = new Google_Client();
        $client->setScopes(Google_Service_Calendar::CALENDAR);
        $appConfig = Factory::getAppConfig();
        $root_url = Factory::getUri()->toString();
        $file_client_secret = $appConfig->get('client_secret_file','');
        if(isset($file_client_secret) && trim($file_client_secret) !== '' && file_exists(TOUROPERATORPRO_PATH_ROOT.DS.$file_client_secret)) {
            $client->setAuthConfig(TOUROPERATORPRO_PATH_ROOT.DS.$file_client_secret);
        } else {
            throw new \Exception("error");
        }
        $modelBooking = Model::getInstance('checkout');
        $input=Factory::getInput();
        $code=$input->getString('code','');
        if(trim($code)!=""){
            $client->authenticate($code);
            $_SESSION['access_token'] = $client->getAccessToken();
        }
        if(isset($_SESSION['current_oder_id']) && $_SESSION['current_oder_id']!=="")
        {
            $order_id=(int)$_SESSION['current_oder_id'];
            $modelBooking->add_google_calendar($order_id);

            header("Location: $root_url/?view=checkout-thanks&order_id=" . $order_id);
            die;

        }else{
            throw new \Exception("error");
        }
    }

}
