"use strict";
(function ($) {
    $.view_tour_detail = function (element, options) {
        let defaults = {
            row_state_template: "",
            tour:{},
            group_size:20,
            discount_amount:0,
            discount_percent:0,
            adult:{
                min:1,
                max:10,
                current:1,
                price:200,
            },
            children:{
                min:0,
                max:10,
                current:0,
                price:180,
            },
            infant:{
                min:0,
                max:10,
                current:0,
                price:100,
            },
            format_currency:'$'
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.counpon').click(function () {
                let $coupon_section=$(this).closest('.coupon-wrap');
                let $coupon_code=$coupon_section.find('input[name="coupon"]');
                let code=$coupon_code.val();
                if(code.trim()===""){
                    $.alert({
                        title: 'Error',
                        content: 'Please input coupon code !',
                    });
                    return;
                }
                plugin.check_coupon($coupon_section);
            })
            $element.find('#example').DataTable();
            $element.find('.body').hide();
            $element.find('#owl-carousel').owlCarousel({
                loop: true,
                margin: 30,
                dots: true,
                nav: false,
                items: 1,
            });
            $element.find('.item:first-child .body').slideDown();
            $element.find('.item:first-child i.fa.fa-angle-down').addClass('rotate-180');

            $element.find(".item").click(function(){
                let $body = $(this).find('.body');
                $body.slideToggle();
                $(this).find('i.fa.fa-angle-down').toggleClass('rotate-180');
            });
            plugin.update_price();
            $element.find(".expand").click(function () {
                let x = $element.find("#expand");
                let $body=$element.find(".body");
                if (x.text() === "Expand All") {
                    $.each($body, function (index, item) {
                        if($(item).css('display') === 'block') {
                            $body.slideUp();
                            x.text("Collapse All");
                            $element.find("i.fa.fa-angle-down").removeClass("rotate-180");
                        }
                    });
                } else {
                    x.text("Expand All");
                    $element.find(".body").slideDown();
                    $element.find("i.fa.fa-angle-down").addClass("rotate-180");
                }
            });
            let now = new Date();
            $element.find('input[name="date_check_in"]').val(moment(now).format('YYYY-MM-DD HH:mm:ss'));
            $element.find('input.date-check-in').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minDate: now,
                minYear: 1970,
                locale: {
                    format: 'DD/MM/YYYY'
                },
                maxYear: '+10',
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $element.find('input[name="date_check_in"]').val(start.format('YYYY-MM-DD HH:mm:ss'))
            });

            $element.find(`input[name="adult_number"]`).val(plugin.settings.adult.current);
            $element.find('.fas.fa-plus').click(function (e) {
                let total=plugin.get_total_person();
                console.log(total)
                let $a_group=$(this).closest('.group-adult-children-infant');
                let group_key=$a_group.data('group_key');
                let current_object=plugin.settings[group_key];
                if(total<plugin.settings.group_size &&  current_object.current<current_object.max){
                    current_object.current++;
                }else{
                    return false;
                }
                $element.find(`input.input-${group_key}`).val(current_object.current);
                $element.find(`input[name="${group_key}_number"]`).val(current_object.current);
                plugin.update_price();
            });
            $element.find('.fas.fa-minus').click(function (e) {
                let $a_group=$(this).closest('.group-adult-children-infant');
                let group_key=$a_group.data('group_key');
                let current_object=plugin.settings[group_key];
                console.log(current_object)
                if(current_object.current>current_object.min){
                    current_object.current--;
                }else{
                    return false;
                }
                $element.find(`input.input-${group_key}`).val(current_object.current);
                $element.find(`input[name="${group_key}_number"]`).val(current_object.current);
                plugin.update_price();
            });



        }
        plugin.update_price = function () {
            let test  = parseFloat(plugin.settings.adult.current);
            console.log(test)
            let total_price= parseFloat(plugin.settings.adult.current*plugin.settings.adult.price+plugin.settings.children.current*plugin.settings.children.price+plugin.settings.infant.current*plugin.settings.infant.price).toFixed(2);
            if(plugin.settings.discount_amount > 0 || plugin.settings.discount_percent > 0) {
                $element.find('.price-original').html(`${plugin.settings.format_currency} ${parseFloat(total_price).toFixed(2)}`);
            }
            if(plugin.settings.discount_amount > 0){
                $element.find('.total-price').html(`${plugin.settings.format_currency} ${parseFloat(total_price - plugin.settings.discount_amount).toFixed(2)}`);
            } else if(plugin.settings.discount_percent > 0) {
                $element.find('.total-price').html(`${plugin.settings.format_currency} ${parseFloat(total_price - total_price * plugin.settings.discount_percent / 100).toFixed(2)}`);
            } else {
                $element.find('.total-price').html(`${plugin.settings.format_currency} ${parseFloat(total_price).toFixed(2)}`);
            }

        };
        plugin.get_total_person = function () {
            return plugin.settings.adult.current+plugin.settings.children.current+plugin.settings.infant.current;
        };
        plugin.check_coupon = function ($coupon_section) {
            let $coupon_code=$coupon_section.find('input[name="coupon"]');
            let code=$coupon_code.val();
            let tour_id=plugin.settings.tour.id;
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task:"checkout.check_coupon",
                    tour_id:tour_id,
                    code:code
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        let coupon= response.data;
                        console.log(coupon)
                        $coupon_section.find('.alert-success').addClass('active');
                    }else {
                        $.alert({
                            title: 'Error',
                            content: 'Incorrect coupon, please try again !',
                        });
                        $coupon_section.find('.alert-success').removeClass('active')
                    }

                },
            });

        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_tour_detail = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_tour_detail')) {
                let plugin = new $.view_tour_detail(this, options);
                $(this).data('view_tour_detail', plugin);
            }
        });
    }
})(jQuery);
