"use strict";
(function ($) {
    $.view_list_tours = function (element, options) {
        let defaults = {
            row_state_template: "",
            data_input:[],
            render_tour_item_grid:"",
            render_tour_item_list:"",
            items_per_page: 8,
            visiblePages: 3,
            min_price:0,
            max_price:1099
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let min_price=parseInt(plugin.settings.min_price);
            let max_price=parseInt(plugin.settings.max_price);
            plugin.filterSystem(10, 100);
            $element.find('select[name="destination"]').select2();
            $element.find('input[class="datetimes"]').daterangepicker({
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY/MM/DD'
                },
                maxYear: '+10',
                minDate: moment().format('YYYY-MM-DD')
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                let rate = `${start.format('YYYY-MM-DD')};${end.format('YYYY-MM-DD')}`;
                $element.find('input[name="rate"]').val(rate)
            });
            $element.find('#slider-container-1').slider({
                range: true,
                min: 0,
                max: 1099,
                values: [min_price, max_price],
                create: function () {
                    $("#amount_1").val("$" + min_price + " - " + "$" + max_price);
                },
                slide: function (event, ui) {
                    $("#amount_1").val("$" + ui.values[0] + " - $" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_search"]`).val(JSON.stringify(price_value));
                }
            });
            $element.find('input[name="sorting_by"]').iCheck({
                checkboxClass: 'icheckbox_minimal',
                radioClass: 'iradio_minimal',
                increaseArea: '20%'
            });
            $element.find('.block-filter-price-more-option').slideUp();
            $element.find('.block-tour-categories').slideUp();
            $element.find('p.more-option').click(function (e) {
                let $block_more_option = $(this).closest('.block-more-option');
                $block_more_option.find('.block-filter-price-more-option').slideToggle();
                $block_more_option.find('.block-tour-categories').slideToggle();
            });
            $element.find('.title-item').click(function (e) {
                let $parent = $(this).parent();
                $parent.find('div:nth-child(2)').slideToggle();
                $(this).toggleClass('slide-up')
            });

            let $wrapper_tour_grid = $element.find('.wrapper-tour-grid');
            let $wrapper_tour_list = $element.find('.wrapper-tour-list');
            let $render_tour_item_grid = $(plugin.settings.render_tour_item_grid);
            let $render_tour_item_list = $(plugin.settings.render_tour_item_list);
            let $tour_render_item_grid = $render_tour_item_grid.filter('.tour-render-item');
            let $tour_render_item_list = $render_tour_item_list.filter('.tour-render-item');
            let items_per_page = plugin.settings.items_per_page;
            let total_result = $tour_render_item_grid.length;
            let total_page = Math.ceil(total_result / items_per_page);
            let visiblePages = (total_page <= 4) ? (total_page % 4): 4;
            let $wrapper_block_result = $element.find('.wrapper-block-result');

            $element.find('.pagination-tour').twbsPagination({
                totalPages: (total_page === 0)?1:total_page ,
                visiblePages: visiblePages,
                onPageClick: function (event, page) {
                    var data_page_1 = $tour_render_item_grid.slice((page - 1) * items_per_page, page * items_per_page);
                    var data_page_2 = $tour_render_item_list.slice((page - 1) * items_per_page, page * items_per_page);
                    $wrapper_tour_grid.empty();
                    $wrapper_tour_list.empty();
                    $.each(data_page_1, function (index, tour) {
                        $wrapper_tour_grid.append(tour.outerHTML)
                    });
                    $.each(data_page_2, function (index, tour) {
                        $wrapper_tour_list.append(tour.outerHTML)
                    });
                    $('body,html').animate({scrollTop: $wrapper_block_result.offset().top}, 500)

                },
                first:'<span class="icon-nb-chevron-left"></span>',
                prev:'<span class="icon-nb-prev"></span>',
                next:'<span class="icon-nb-next"></span>',
                last:'<span class="icon-nb-chevron-right"></span>',
            });

        };

        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).dname=oeschgerata("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_tours = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_tours')) {
                let plugin = new $.view_list_tours(this, options);
                $(this).data('view_list_tours', plugin);
            }
        });
    }
})(jQuery);
