"use strict";
(function ($) {
    $.view_checkout_default = function (element, options) {
        let defaults = {
            tour:{}
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.check_coupon').click(function () {
                let $coupon_section=$(this).closest('.coupon-section');
                let $coupon_code=$coupon_section.find('input[name="coupon_code"]');
                let code=$coupon_code.val();
                if(code.trim()===""){
                    $.alert({
                        title: 'Error',
                        content: 'Please input coupon code !',
                    });
                    return;
                }
                $coupon_code.prop('disabled',true);
                $(this).prop('disabled',true);
                plugin.check_coupon($coupon_section);
            })

        }
        plugin.check_coupon = function ($coupon_section) {
            let $coupon_code=$coupon_section.find('input[name="coupon_code"]');
            let code=$coupon_code.val();
            let tour_id=plugin.settings.tour.id;
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task:"checkout.check_coupon",
                    tour_id:tour_id,
                    code:code
                },
                beforeSend: function () {

                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        let coupon=response.data;


                    }
                }
            });

        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_checkout_default = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_checkout_default')) {
                let plugin = new $.view_checkout_default(this, options);
                $(this).data('view_checkout_default', plugin);
            }
        });
    }
})(jQuery);
