<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Activities");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');

$curent_user_id = FactoryAlias::getUser()->id;

?>
<?php ?>
    <form  name="admin_woopanel-form" method="post">
        <div class="view-list-activities">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th ><?php echo (HtmlBackend::render_checkbox('All')) ?></th>
                        <th ><?php esc_attr_e('ID','touroperatorpro')?></th>
                        <th ><?php esc_attr_e('Tour ID','touroperatorpro')?></th>
                        <th ><?php esc_attr_e('Tour Name','touroperatorpro')?></th>
                        <th ></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <?php
                        if ($item->user_id == $curent_user_id):
                    ?>
                    <tr>
                        <td ><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td ><?php esc_html_e($item->id); ?></td>
                        <td ><?php esc_html_e($item->tour_id); ?></td>
                        <td ><?php esc_html_e($item->tour_name); ?></td>
                        <td class="tour-action nowrap">
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("wishlist","wishlist.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php
                        endif;
                    ?>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="activities.add">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/list_activity.less');
$doc->addScriptApplySelector('.view-list-activities', 'view_list_activities', array(

), "admin/app/assets/js/view_list_activities.js");
?>