<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List tour type");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("tourtype.form")) ?>" name="admin-form" method="post">
        <div class="view-list-tour-type">
            <table id="example" class="display table">
                <thead>
                <tr>
                    <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                    <th><?php esc_attr_e('Tour type name','touroperatorpro'); ?></th>
                    <th><?php esc_attr_e('Description','touroperatorpro'); ?></th>
                    <th><?php esc_attr_e('Published','touroperatorpro'); ?></th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($this->list as $item) { ?>
                    <tr>
                        <td><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="tourtype-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="tourtype-description"><?php echo ($item->description); ?></td>
                        <td class="tourtype-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="Public"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="Not-Public"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="tourtype-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("tourtype.form", array("id" => $item->id))) ?>"
                               class="btn-edit" data-task="edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("tourtype", 'tourtype.delete', array("id" => $item->id))) ?>"
                               class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_tour_type.less');
$doc->addScriptApplySelector('.view-list-tour-type', 'view_list_tourtype', array(), "admin/app/assets/js/view_list_tourtype.js");
?>