<?php
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\TourOperatorProHtmlBackend;
use TourOperatorProAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;
use TourOperatorPro\Language\Text;
$doc= FactoryAlias::getDocument();
TourOperatorProHtmlBackend::daterangepicker();
?>
<div class="view-form-tours">
    <form action="" name="admin-form" method="post" enctype="multipart/form-data">

        <div>
            <ul class="tour-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                                          data-toggle="tab"> <?php esc_attr_e('Detail tour','touroperatorpro') ?></a></li>
                <li role="presentation"><a href="#profile" aria-controls="profile" role="tab"
                                           data-toggle="tab"><?php esc_attr_e('Gallery','touroperatorpro') ?></a></li>
                <li role="presentation"><a href="#itineraries" aria-controls="profile" role="tab"
                                           data-toggle="tab"><?php esc_attr_e('Itineraries','touroperatorpro') ?></a></li>
                <li role="presentation"><a href="#customize" aria-controls="customize" role="tab"
                                           data-toggle="tab"><?php esc_attr_e('Customize','touroperatorpro') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field = $this->form->getField('image');
                            ?>
                            <?php echo ($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('language')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('destination')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('activity')) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('tourtype')) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('season')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('price')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('adult_price')) ?>
                        </div>
                    </div>
                    <div class="row">

                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('children_price')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('infant_price')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('duration')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('rating')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('group_size')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php
                                $field = $this->form->getField('published')
                            ?>
                            <?php echo ($field->input) ?>
                        </div>
                        <div class="col-md-6">
                            <?php
                                $field = $this->form->getField('is_feature')
                            ?>
                            <?php echo ($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p><?php echo ($this->form->renderField('highlight')) ?></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p><?php echo ($this->form->renderField('included')) ?></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p><?php echo ($this->form->renderField('excluded')) ?></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p><?php echo ($this->form->renderField('description')) ?></p>
                        </div>
                    </div>

                </div>
                <div role="tabpanel" class="tab-pane" id="profile">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('gallery')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="itineraries">
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field = $this->form->getField('itineraries');
                            ?>
                            <?php echo ($field->input) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="customize">
                    <?php
                    foreach ($this->list_customize as $customize) {
                        echo HtmlCustomFieldBackend::render_by_type($customize);
                    }


                    
                    ?>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="tour.save">

    </form>
</div>
<?php
$doc->addLessStyleSheet("admin/app/assets/less/view_form_tour.less");
$doc->addScriptApplySelector('.view-form-tours', 'view_form_tour', array(

), "admin/app/assets/js/view_form_tour.js");
?>
