<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List tourpackages");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("tourpackages.form")) ?>" name="admin-form" method="post">
        <div class="view-list-tourpackages">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Tour package name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Image','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Description','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="tour-package-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="tour-package-image">
                            <div class="img-box">
                                <div>
                                    <img src="<?php echo(FactoryAlias::getRootUrlPlugin().'/'.$item->image) ?>">
                                </div>
                            </div>
                        </td>
                        <td class="tour-package-description">
                            <div><?php echo ($item->description); ?></div>
                        </td>
                        <td class="tour-packgae-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("tourpackages.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView('tourpackages','tourpackage.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="tourpackages.add">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/list_tourpackage.less');
$doc->addScriptApplySelector('.view-list-tourpackages', 'view_list_tourpackages', array(

), "admin/app/assets/js/view_list_tourpackages.js");
?>