<?php

namespace TourOperatorProAdminWooPanel\app\views\tourpackages;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class TourpackagesView extends View
{
    public function display($tpl)
    {

        $modelTourpackage = Model::getInstance("tourpackage");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("tourpackage.add");
                ToolBar::delete("tourpackage.delete_list");
                ToolBar::_clone("tourpackage.clone_list");
                $model = Model::getInstance("tourpackages");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Tourpackage');
                ToolBar::apply("tourpackage.apply");
                ToolBar::save("tourpackage.save");
                ToolBar::cancel("tourpackage.cancel");
                ToolBar::back_to_list("tourpackage.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelTourpackage->getItem($id);
                $this->form = $modelTourpackage->getForm();
                break;
        }
        return parent::display($tpl);
    }
}