<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility;

TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
TourOperatorProHtmlBackendAlias::load_jquery_library('confirm');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/view_tool.less');
$input = Factory::getInput();
$step = $input->getInt('step', 0);
$step++;
$toolChecked = $input->get('tool', array(), 'array');
?>
    <div class="view-tool-form">
        <div class="notification-before-download hide">
            <p><?php esc_attr_e('Before download please check database structor','touroperatorpro')?></p>
            <p><?php esc_attr_e('When you successfully download please open with phpstorm then check the error code','touroperatorpro')?></p>
        </div>
        <div class="tool-bar">
            <div class="row">
                <div class="col-md-12">
                    <div class="pull-right">
                        <a class="btn btn-primary"
                           href="<?php echo ($this->goToTaskLink('tool', 'create_view')) ?>"><?php esc_attr_e('Create view','touroperatorpro') ?></a>
                        <a class="btn btn-primary"
                           href="<?php echo ($this->goToTaskLink('tool', 'list_page_front_end')) ?>"><?php esc_attr_e('List page frontend','touroperatorpro') ?></a>

                        <a class="btn btn-primary"
                           href="<?php echo ($this->goToTaskLink('tool', 'setup_view')) ?>"><?php esc_attr_e('Setup view','touroperatorpro') ?></a>
                        <a class="btn btn-primary"
                           href="<?php echo ($this->goToTaskLink('tool', 'create_sample_data')) ?>"><?php esc_attr_e('Create sample data','touroperatorpro') ?></a>
                        <a class="btn btn-primary btn-download-package"
                           href="<?php echo ($this->goToTaskLink('tool', 'download_package')) ?>"><?php esc_attr_e('Download package','touroperatorpro') ?></a>
                        <a class="btn btn-primary btn-download-package"
                           href="<?php echo ($this->goToTaskLink('tool', 'import_data_tour')) ?>"><?php esc_attr_e('Import data tour','touroperatorpro') ?></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-main-tool">
            <form action="" name="admin-form" method="post">
                <div class="row">
                    <div class="col-md-offset-3 col-md-9">
                        <h3 class="setup"><?php esc_attr_e('Setup','touroperatorpro') ?></h3>
                    </div>
                </div>
                <div class="body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="wrapper-tool">
                                <ul class="list-tool">
                                    <li>
                                        <label>
                                            <input class="tool-item" name="tool[]" <?php esc_attr_e(in_array("setup_sample_page", $toolChecked) ? ' checked ' : '') ?> value="setup_sample_page" type="checkbox">
                                            <?php esc_attr_e('Setup page sample','touroperatorpro') ?>
                                        </label>
                                    </li>
                                    <li>
                                        <label>
                                            <input class="tool-item" name="tool[]" <?php esc_attr_e(in_array("setup_sample_database", $toolChecked) ? ' checked ' : '')?> value="setup_sample_database" type="checkbox" />
                                            <?php esc_attr_e('Setup sample database','touroperatorpro') ?>
                                        </label>
                                    </li>
                                    <li>
                                        <label>
                                            <input class="tool-item" name="tool[]" <?php esc_attr_e(in_array("backup_database", $toolChecked) ? ' checked ' : '') ?> value="backup_database" type="checkbox" />
                                            <?php esc_attr_e('Backup database','touroperatorpro') ?>
                                        </label>
                                    </li>
                                    <li>
                                        <label>
                                            <input class="tool-item" name="tool[]" <?php esc_attr_e(in_array("backup_media", $toolChecked) ? ' checked ' : '') ?> value="backup_media" type="checkbox" />
                                            <?php esc_attr_e('Backup media','touroperatorpro') ?>
                                        </label>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-9">
                            <div class="description">
                                <?php esc_attr_e('Description when hover tool','touroperatorpro') ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="tool-bar pull-right">
                            <button class="btn btn-primary btn-next" type="button"><?php  esc_attr_e('Next','touroperatorpro') ?></button>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="step" value="<?php echo ($step) ?>">
                <input type="hidden" name="task" value="tool.next">
            </form>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-tool-form','view_tool',array(
    "step"=>  (int)$step,
    "tool_check"=>  json_encode($toolChecked),
),'admin/app/assets/js/view_tool.js');
