<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorPro\Language\Text;
use TourOperatorProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List states");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("states.form")) ?>" name="admin-form" method="post">
        <div class="view-list-states">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('State name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Country name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Publish','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="state-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="country-name"><?php echo ($item->country_name); ?> </td>
                        <td class="state-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="Public"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="Not-Public"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="state-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("states.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("states","state.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_states.less');
$doc->addScriptApplySelector('.view-list-states', 'view_list_states', array(

), "admin/app/assets/js/view_list_states.js");
?>