<?php

namespace TourOperatorProAdminWooPanel\app\views\seasons;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class SeasonsView extends View
{
    public function display($tpl)
    {
        $modelSeason = Model::getInstance("season");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("season.add");
                ToolBar::delete("season.delete_list");
                ToolBar::_clone("season.clone_list");
                $model = Model::getInstance("seasons");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Season');
                ToolBar::apply("season.apply");
                ToolBar::save("season.save");
                ToolBar::cancel("season.cancel");
                ToolBar::back_to_list("season.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelSeason->getItem($id);
                $this->form = $modelSeason->getForm();
                break;
        }
        return parent::display($tpl);
    }
}