<?php
use TourOperatorPro\Language\Text;
use TourOperatorProAdmin\app\Html\HtmlBackend;
?>
<div class="view-order-form">
    <form action="" name="admin-form" method="post" enctype="multipart/form-data">
        <table class="table table-bordered">
            <tr>
                <th width="40%"><?php esc_attr_e('Order id','touroperatorpro'); ?></th>
                <td><?php esc_html_e($this->item->id); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Customer name','touroperatorpro'); ?></th>
                <td><?php isset($this->item->customer->full_name)?esc_html_e($this->item->customer->full_name):''; ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Tour name','touroperatorpro'); ?></th>
                <td><?php isset($this->item->tour->name)?esc_html_e($this->item->tour->name):''; ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Check in','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->start_date)?HtmlBackend::render_date($this->item->order_detail->start_date):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Adult','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->adult)?esc_html_e($this->item->order_detail->adult):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Children','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->children)?esc_html_e($this->item->order_detail->children):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Infant','touroperatorpro'); ?></th>
                <td><?php echo (isset($this->item->order_detail->infant)?esc_html_e($this->item->order_detail->infant):''); ?></td>
            </tr>
            <tr>
                <th><?php esc_attr_e('Change order status','touroperatorpro'); ?></th>
                <td>
                    <?php
                    $field = $this->form->getField('order_status_id');
                    ?>
                    <?php echo ($field->input) ?>

                </td>
            </tr>
        </table>

        <?php echo ($this->form->renderField('id')) ?>
    </form>
</div>
