<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Orderpackage");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("orderpackages.form")) ?>" name="admin-form" method="post">
        <div class="view-list-orderpackages">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th class="nowrap"><?php esc_attr_e('Orderpackage name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Image','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Description','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="order-package-name">
                            <h4>
                                <?php echo ($item->name); ?>
                            </h4>
                        </td>
                        <td class="order-package-image">
                            <div class="img-box">
                                <div>
                                    <img src="<?php  echo(FactoryAlias::getRootUrlPlugin().'/'.$item->image) ?>; ?>">
                                </div>
                            </div>
                        </td>
                        <td class="order-package-description">
                            <div>
                                <?php echo ($item->description); ?>
                            </div>
                        </td>
                        <td class="order-package-action">
                            <a href="<?php echo(UtilityAlias::getBackendGoToLink("orderpackages.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByView('orderpackages','orderpackage.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="orderpackages.add">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/list_orderpackage.less');
$doc->addScriptApplySelector('.view-list-orderpackages', 'view_list_orderpackages', array(

), "admin/app/assets/js/view_list_orderpackages.js");
?>