<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Discounts");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("discount.form")) ?>" name="admin-form" method="post">
        <div class="view-list-discounts">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Discount name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Tour name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Description','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Publish','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="discount-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="tour-name">
                            <?php foreach ($item->list_tour as $tour){ ?>
                                <?php echo "$tour->name <br/>" ?>
                            <?php } ?>
                        </td>
                        <td class="discount-description">
                            <div><?php echo ($item->description); ?></div>
                        </td>
                        <td class="discount-published"><?php esc_html_e($item->published == 1? 'Public': 'Not public'); ?></td>
                        <td class="discount-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("discount.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel('discount','discount.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="discounts.add">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_discount.less');
$doc->addScriptApplySelector('.view-list-discounts', 'view_list_discounts', array(

), "admin/app/assets/js/view_list_discounts.js");
?>