<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/view_list_destination.less');
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List destinations");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("destinations.form")) ?>" name="admin-form" method="post">
        <div class="view-list-destinations">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Address','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Phone number','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('State country','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="destination-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="destination-address">
                            <p><?php echo ($item->address); ?> </p>
                        </td>
                        <td class="destination-phone"><?php echo ($item->mobile); ?> </td>
                        <td class="destination-country-name"><?php echo ($item->state_name.' - '.$item->country_name); ?> </td>
                        <td class="destination-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("destinations.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("destinations",'destination.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-destinations', 'view_list_destinations', array(

), "admin/app/assets/js/view_list_destinations.js");
?>