<?php

namespace TourOperatorProAdminWooPanel\app\views\destinations;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorProAdmin\app\helpers\CustomizeHelper;

class DestinationsView extends View
{
    public function display($tpl)
    {
        $modelDestination = Model::getInstance("destination");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("destination.add");
                ToolBar::delete("destination.delete_list");
                ToolBar::_clone('destination.clone_list');
                $model = Model::getInstance("destinations");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit destinations');
                ToolBar::save("destination.save");
                ToolBar::cancel('destination.cancel');
                ToolBar::apply('destination.apply');
                ToolBar::back_to_list('destination.back_to_list');
                $id = $input->getInt('id', 0);
                $this->item = $modelDestination->getItem($id);
                $this->form = $modelDestination->getForm();
                $this->list_customize=CustomizeHelper::get_list_customize("location");
                $this->list_customize=CustomizeHelper::assignValue( $this->list_customize,$this->item);
                break;
        }
        return parent::display($tpl);
    }
}