<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Html\TourOperatorProHtmlBackend;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Language\Text;
use TourOperatorProAdmin\app\Html\HtmlBackend;

$doc = Factory::getDocument();
TourOperatorProHtmlBackend::load_jquery_library('chart_js');
TourOperatorProHtmlBackend::load_jquery_library('bootstrap_tabs');
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_db_appointments_dashboard.less');
$number_user= count((array)$this->list_customer);
$number_month=count((array)$this->list_order_by_month);
$number_month_order=count((array)$this->list_order_by_month,1);
$number_oder= $number_month_order - $number_month;
$number_activities= count((array)$this->list_activities);
$total=0;
?>
    <div class="view-db-appointments-dashboard">
        <h2 class="title"><i class="fab fa-buromobelexperte"></i> <?php esc_attr_e('touroperatorpro','touroperatorpro') ?></h2>
        <div class="row">
            <div class="col-md-3">
                <div class="block-item-widget user">
                    <div class="icon-block">
                        <i class="fas fa-user-friends"></i>
                    </div>
                    <div class="content-block">
                        <h4> <?php esc_attr_e('New users','touroperatorpro') ?></h4>
                        <p><?php echo ($number_user?$number_user:0); ?> <?php esc_attr_e('New users','touroperatorpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget order">
                    <div class="icon-block">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_attr_e('New orders','touroperatorpro') ?></h4>
                        <p><?php esc_html_e($number_oder);  ?> <?php esc_attr_e('new orders','touroperatorpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget delivery">
                    <div class="icon-block">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_attr_e('Activities','touroperatorpro') ?></h4>
                        <p><?php esc_html_e($number_activities);  ?> <?php esc_attr_e('Activities','touroperatorpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget monthly">
                    <div class="icon-block">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="content-block">
                        <?php foreach ($this->list_order_in_year as $item) { ?>
                            <?php $total += $item->total ?>
                        <?php } ?>
                        <h4><?php esc_attr_e('Yearly_profits','touroperatorpro') ?></h4>
                        <p><?php echo (HtmlBackend::render_price($total)); ?> <?php esc_attr_e('This year','touroperatorpro') ?></p>
                    </div>
                </div>
            </div>

        </div>
        <div class="total-order">
            <h3><?php esc_attr_e('Total order','touroperatorpro') ?></h3>
            <canvas class="order-this-week"></canvas>
        </div>
        <div class="monthly-profits">
            <h3><?php esc_attr_e('Month profits','touroperatorpro') ?></h3>
            <canvas class="employee-chart"></canvas>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="new-customer">
                    <h3><?php esc_attr_e('New customer','touroperatorpro') ?></h3>
                    <table class="table table-responsive">
                        <thead>
                        <tr>
                            <th class="nowrap"><?php esc_attr_e('Id','touroperatorpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Name','touroperatorpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Phone','touroperatorpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Order time','touroperatorpro') ?> </th>
                        </tr>
                        </thead>
                        <tbody class="list-wbcustomer main-table">
                        <?php foreach ($this->list_customer as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_customer') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-6">
                <div class="list-activity">
                    <h3><?php esc_attr_e('List activities','touroperatorpro') ?></h3>
                    <table class="table table-responsive">
                        <thead>
                        <tr>
                            <th class="view-list-activity-th nowrap"><?php esc_attr_e('Id','touroperatorpro') ?></th>
                            <th class="view-list-activity-th nowrap"><?php esc_attr_e('Name','touroperatorpro') ?></th>
                            <th class="view-list-activity-th nowrap"><?php esc_attr_e('Image','touroperatorpro') ?></th>
                        </tr>
                        </thead>
                        <tbody class="list-activity main-table">
                        <?php foreach ($this->list_activities as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_activity') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-db-appointments-dashboard','view_db_appointments_dashboard',array(
    "list_order_by_month"=>$this->list_order_by_month
),'admin_woopanel/app/assets/js/view_db_appointments_dashboard.js');