<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdmin\app\Html\HtmlBackend;
use TourOperatorPro\Language\Text;
$doc = FactoryAlias::getDocument();
TourOperatorProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Customize");
TourOperatorProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("customize.form")) ?>" name="admin-form" method="post">
        <div class="view-list-customize">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th></th>
                        <th><?php esc_attr_e('Table','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Label','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Field','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Type','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Backend','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Frontend','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Default value','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="customize-table">
                            <?php esc_html_e (ucfirst($item->table_view)); ?>
                        </td>
                        <td class="customize-label">
                            <?php esc_html_e ($item->label_field); ?>
                        </td>
                        <td class="customize-field">
                            <?php esc_html_e ($item->field_name); ?>
                        </td>
                        <td class="customize-type">
                            <?php esc_html_e ($item->type); ?>
                        </td>
                        <td class="customize-backend">
                            <?php if ($item->backend == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="customize-frontend">
                            <?php if ($item->frontend == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="customize-type">
                            <?php esc_html_e ($item->default_value); ?>
                        </td>

                        <td class="customize-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("customize.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel('customize','customize.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="customize.add">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_customize.less');
$doc->addScriptApplySelector('.view-list-customize', 'view_list_customize', array(

), "admin/app/assets/js/view_list_customize.js");
?>