<?php

use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Html\TourOperatorProHtmlWooPanel as TourOperatorProHtmlWooPanelAlias;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_customers.less');
TourOperatorProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Customer");
TourOperatorProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("customers.form")) ?>" name="admin-form" method="post">
        <div class="view-list-customers">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Customer name','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Phone','touroperatorpro'); ?></th>
                        <th><?php esc_attr_e('Birthday','touroperatorpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id))?></td>
                        <td class="customer-name"><?php echo ($item->first_name); ?> <?php echo ($item->last_name); ?></td>
                        <td class="customer-phone"><?php echo ($item->mobile); ?></td>
                        <td class="customer-birthday"><?php echo ($item->birth_day); ?></td>
                        <td class="customer-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("customers.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','touroperatorpro')?>"><i class="fas fa-edit"></i> </a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("customers","customer.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','touroperatorpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="customer.save">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-customers', 'view_list_customers', array(), "admin_woopanel/app/assets/js/view_list_customers.js");
?>