<?php

namespace TourOperatorProAdminWooPanel\app\views\countries;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class CountriesView extends View
{
    public function display($tpl)
    {
        $modelTour = Model::getInstance("country");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("country.add");
                ToolBar::delete("country.delete_list");
                ToolBar::_clone("country.clone_list");
                $model = Model::getInstance("countries");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Country');
                ToolBar::save("country.save");
                ToolBar::cancel("country.cancel");
                ToolBar::apply("country.apply");
                ToolBar::back_to_list("country.back_tour_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelTour->getItem($id);
                $this->form = $modelTour->getForm();

                break;
        }
        return parent::display($tpl);
    }
}