<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Language\Text;
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/view_form_config.less');
?>
<div class="view-config-form">
    <form action="" name="admin-form" method="post">
        <div>
            <ul class="event-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#basic" aria-controls="home" role="tab"
                                                          data-toggle="tab"><?php esc_attr_e('basic','touroperatorpro') ?></a></li>
                <li role="presentation"><a href="#booking" aria-controls="profile" role="tab"
                                           data-toggle="tab"><?php esc_html_e("Booking",'touroperatorpro') ?></a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="basic">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('page_tour_detail','params')) ?>
                            <h3>Short code : [touroperatorpro view="tours-detail"]</h3>
                            <?php echo(ToolBar::render_button_task("config.create_page_tour_detail",touroperator_get_content("Create page tour detail"))) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('page_tour_checkout','params')) ?>
                            <h3>Short code : [touroperatorpro view="checkout-default"]</h3>
                            <?php echo(ToolBar::render_button_task("config.create_page_tour_checkout",touroperator_get_content("Create page tour checkout"))) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('page_list_tour','params')) ?>
                            <h3>Short code : [touroperatorpro view="tours-list"]</h3>
                            <?php echo(ToolBar::render_button_task("config.create_page_list_tour",touroperator_get_content("Create page tour list"))) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('page_list_tour_search_result','params')) ?>
                            <h3>Short code : [touroperatorpro view="tours-list"]</h3>
                            <?php echo(ToolBar::render_button_task("config.create_page_list_tour_search_result",touroperator_get_content("Create page tour list search result"))) ?>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div role="tabpanel" class="tab-pane" id="booking">
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value="config.save">
    </form>
</div>
