<?php

namespace TourOperatorProAdminWoopanel\app\views\activities;

use TourOperatorPro\Html\ToolBar;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;
use TourOperatorPro\Factory as FactoryAlias;

class ActivitiesView extends View
{
    public function display($tpl)
    {
        $modelActivity = Model::getInstance("activity");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("activity.add");
                ToolBar::delete("activity.delete_list");
                ToolBar::_clone("activity.clone_list");
                $model = Model::getInstance("activities");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Activity');
                ToolBar::apply("activity.apply");
                ToolBar::save("activity.save");
                ToolBar::cancel("activity.cancel");
                ToolBar::back_to_list("activity.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelActivity->getItem($id);
                $this->form = $modelActivity->getForm();

                break;
        }
        return parent::display($tpl);
    }
}