<?php
namespace TourOperatorProAdminWoopanel\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
class WishlistsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "wishlists";
    /**
     * @var string
     */
    public $table_name = "wishlist";
    public function getListQuery()
    {
        $query = $this->_db->getQuery(true);
        $query->clear()
            ->select('wishlist.*')
            ->from($this->getTableName() . ' AS wishlist')
            ->leftJoin($this->getTableName('tour') . ' AS tour ON tour.id =wishlist.tour_id')
            ->group('wishlist.tour_id')
            ->select('tour.name  AS tour_name')
            ->select("COUNT(wishlist.tour_id) AS total");
        return $query;
    }
    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();
        $list =  $db->setQuery($query)->loadObjectList();

        return $list;
    }
}
