<?php
namespace TourOperatorProAdminWoopanel\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use Exception;
use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Filesystem\File as FileAlias;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorPro\Utilities\Utility;

class SeasonModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "season";
    /**
     * @var string
     */
    public $table_name = "season";

    public function save($data = array())
    {
        $item= parent::save($data); // TODO: Change the autogenerated stub
        $image=Factory::getInput()->files->get('image','','raw');
        if(!empty($image['name'])) {
            $name = str_replace(' ', '_',Utility::gen_random_string()) . $image['name'];
            $short_path_image = "upload/seasons/images/cover/$name";
            $new_file_image_season_path = TOUROPERATORPRO_PATH_ROOT . DS . $short_path_image;
            if (!FileAlias::write($new_file_image_season_path, FileAlias::read($image['tmp_name']))) {
                throw new Exception(Text::_("can not upload image cover"));
            }
            $item->image = $short_path_image;
            $data = (array)$item;
            $item = parent::save($data);
        }
        return $item;
    }



}
