<?php
namespace TourOperatorProAdminWoopanel\app\models;
defined('_TOUROPERATOR_EXEC') or die;

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\ModelForm;
use TourOperatorPro\Filesystem\File as FileAlias;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Form\Form;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Registry\Registry;
use TourOperatorPro\Utilities\Utility;

class OrderModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "order";
    /**
     * @var string
     */
    public $table_name = "order";

    public function getItem($id = 0)
    {
        $item= parent::getItem($id); // TODO: Change the autogenerated stub
        if(isset($item->id) && $item->id !=0) {
            $query = $this->db->getQuery(true);
            $query->select('order_detail.*')
                ->from($this->getTableName('order_detail') . ' AS order_detail')
                ->where('order_detail.order_id=' . (int)$item->id);
            $item->order_detail = $this->db->setQuery($query)->loadObject();

            $query->select('customer.*')
                ->from($this->getTableName('customer') . ' AS customer')
                ->where('customer.id=' . (int)$item->customer_id);
            $item->customer = $this->db->setQuery($query)->loadObject();
            if( $item->customer)
            {
                $item->customer->full_name=Utility::get_full_name($item->customer->first_name,$item->customer->last_name);
            }
            $query->select('tour.*')
                ->from($this->getTableName('tour') . ' AS tour')
                ->where('tour.id=' . (int)(isset($item->order_detail->tour_id)?$item->order_detail->tour_id:0));
            $item->tour = $this->db->setQuery($query)->loadObject();

        }
        return $item;
    }


}
