<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility;
defined('WPBOOKINGPRO_PATH_BASE') or die;
extract($displayData);



$id_by_name = "element_field_". $name;
$list_selected = $value;
$list_view = WpBookingPro_Helper::function_get_view();
TourOperatorProHtmlBackend::load_jquery_library('icheck');
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-views">
        <ul name="<?php esc_attr_e($name); ?>" class=" list-view">
			<?php foreach ($list_view as $view) { ?>
                <li value="">
                    <label><input type="checkbox" <?php echo ($view->is_system) || in_array($view->menu_slug,
							$list_selected) ? ' checked ' : '' ?> <?php echo ($view->is_system ? ' disabled ' : '') ?>
                                  name="<?php esc_attr_e($name); ?>[]"
                                  value="<?php esc_attr_e($view->menu_slug); ?>"> <?php esc_html_e($view->label); ?>
                    </label>
                </li>
			<?php } ?>
        </ul>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/views.less');
$doc->addScriptApplySelector('.field-views','field_views',array(
    "field_name"=>  $name,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/views.jquery.js');
