<?php
use TourOperatorPro\Language\Text;
use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelTours = Model::getInstance('tours');
$list = $modelTours->getList();
$list_time = [];
$list_tour_id = [];
if (!is_array($value)) {
	$list_tour_id[] = $value;
} else {
	$list_tour_id = $value;
}
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-tour">
        <select name="<?php esc_attr_e($name); ?>"
                required="<?php esc_attr_e($required) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-tour">
            <option value=""><?php esc_html_e('Select tour','touroperatorpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->id, $list_tour_id) ? ' selected ' : null) ?>
                        value="<?php esc_attr_e($item->id); ?>"><?php esc_html_e($item->name); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/tour/tour.less');
$doc->addScriptApplySelector('.field-tour','field_tour',array(
),'admin/app/layouts/WooBooking/form/field/tour/tour.jquery.js');