<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Html\TourOperatorProHtmlBackend;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility;
use TourOperatorProAdmin\app\helpers\CustomizeHelper;

defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackend::load_jquery_library('dateselect');
TourOperatorProHtmlBackend::load_jquery_library('select2');




$doc = Factory::getDocument();
$list_table_view = CustomizeHelper::getListTableView();
$id_by_name = "element_field_". $name;
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-tableview">
        <select class="table-view" name="<?php esc_attr_e($name); ?>" <?php echo $disabled?" disabled ":"" ?> >
            <option value=""><?php esc_attr_e('Select table','touroperatorpro') ?></option>
			<?php foreach ($list_table_view as $table) { ?>
                <?php
                    $table = str_replace('tbpro_','',$table);
                ?>
                <option <?php echo ($value == $table ? ' selected ' : '') ?>
                        value="<?php esc_attr_e($table) ?>"><?php esc_html_e(ucfirst(str_replace('_',' ',$table))) ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/tableview/tableview.less');
$doc->addScriptApplySelector('.field-tableview','field_tableview',array(
    "input_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/tableview/tableview.jquery.js');
