<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelStates = Model::getInstance('states');
$list = $modelStates->getList();
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-states">
        <div class="wrapper-state">
            <input class="state" type="text" value="<?php esc_attr_e($value) ?>">
            <input type="hidden" name="<?php esc_attr_e($name) ?>" value="<?php esc_attr_e($value) ?>">
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/states/states.less');
$doc->addScriptApplySelector('.field-states','field_states',array(
    "list_state"=>  $list,
    "input_field"=>  $name,
),'admin/app/layouts/WooBooking/form/field/states/states.jquery.js');