"use strict";
(function ($) {
    $.field_recurring = function (element, options) {
        var defaults = {
            values: [],
            max_recurring: 10
        }
        var plugin = this;
        plugin.settings = {};
        var $element = $(element);
        plugin.init = function () {
            $ = jQuery;
            var main_id_element1 = '#<?php Text::_echo_no_translate($id_by_name) ?>';
            $element.find('.until-when').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minYear: 1901,
                maxYear: parseInt(moment().format('YYYY'), 10),
                isInvalidDate: function(date) {
                    if (date.format('YYYY-MM-DD') < moment().format('YYYY-MM-DD')) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }, function (start, end, label) {
                $('input[name="<?php Text::_echo_no_translate($name_recurring_until) ?>"]').val(start.format('YYYY-MM-DD'));
            });
            $element.find('.repeat-event').select2();
            $element.find('.label').on('click',function (e) {
                if (!$(this).find('input[type="checkbox"]').is(':checked')) {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');
                } else {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                }
            });
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '10%' 
            });
        }
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_recurring = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_recurring')) {
                var plugin = new $.field_recurring(this, options);
                $(this).data('field_recurring', plugin);
            }
        });
    }
})(jQuery);