<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
TourOperatorProHtmlBackendAlias::load_jquery_library('moment');


$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/rates/rates.less');
$id_by_name = "element_field_". $name;
$calendar_element_field_id="calendar_$id_by_name";
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-rates">
        <div class="wrapper-rates">
            <div id="<?php esc_attr_e($calendar_element_field_id )?>" class="calendar_rates"></div>
            <input type="hidden" required="<?php esc_attr_e($required) ?>"
                   name="<?php esc_attr_e($name); ?>" value="<?php esc_attr_e($value) ?>">
        </div>
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_rates',array(
    "input_name"=>  $name,
),'admin/app/layouts/WooBooking/form/field/rates/jquery.rates.js');
