<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Html\TourOperatorProHtmlBackend;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Utilities\Utility;

defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
TourOperatorProHtmlBackend::load_jquery_library('ui');
TourOperatorProHtmlBackend::load_jquery_library('select2');
TourOperatorProHtmlBackend::load_jquery_library('fontawesome');
TourOperatorProHtmlBackend::load_jquery_library('daterangepicker');
TourOperatorProHtmlBackend::load_jquery_library('moment');

$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/rate/rate.less');
$id_by_name = "element_field_". $name;
$list_rate = (array)$value;


$template_range_date = function ($name, $from, $to, $required) {
    $from = Factory::getDate($from);
    if (!$from->getTimestamp()) {
        $from = clone Factory::getDate();
    }
    $from = $from->toSql();
    $to = Factory::getDate($to);
    if (!$to->getTimestamp()) {
        $to = clone Factory::getDate();
    }
    $to = $to->toSql();
    ob_start();
    ?>
    <div class="item">
        <div class="input-rate">
            <input type="text" class="form-control m-input rate"
                   value="<?php esc_attr_e($from && $to ? "$from;$to" : '') ?>"/>
        </div>
        <div class="controllers">
            <button type="button" class="btn btn-add btn-primary pull-left"><i class="far fa-copy"></i>
            </button>
            <button type="button" class="btn btn-close-item btn-primary pull-left"><i
                        class="far fa-trash-alt"></i></button>
        </div>
        <input type="hidden" class="rates" required="<?php esc_attr_e($required) ?>"
               value="<?php esc_attr_e($from && $to ? "$from;$to" : '') ?>"
               name="<?php esc_attr_e($name); ?>[]">
    </div>
    <?php
    return ob_get_clean();
};
$item_rate = '';
$max_rate = $max_rate ? $max_rate : 10
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-input-rate">
        <div class="list-item">
            <?php if (count($list_rate) == 0) {
                esc_html_e($template_range_date($name, null, null, $required));
            } else { ?>
                <?php foreach ($list_rate as $key => $rate) {
                    esc_html_e($template_range_date($name, $rate->from, $rate->to, $required));
                } ?>
            <?php } ?>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.field-input-rate', 'field_rate', array(
    "item_rate" => $template_range_date($name, "", "", $required),
    "input_name" => $name . '[]',
    "max_rate" => $max_rate,
    "values" => $value,
), 'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/rate/rate.jquery.js');
