<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);
TourOperatorProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$modelCountry = Model::getInstance('countries');
$list = $modelCountry->getList();
foreach ($list as &$item) {
	$item->id = $item->countrycode;
	$item->text = $item->countryname;
}
$data = $displayData['field']->getForm()->getData();
$country_code = $data->def('country_code', $default_country_code);
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-phonenumber">
        <div class="wrapper-phone-number">
            <input class="countries" name="<?php esc_attr_e($field_name_country_code) ?>"
                   value="<?php esc_attr_e($country_code) ?>" type="text">
            <input class="phone_number" name="<?php esc_attr_e($name); ?>" value="<?php esc_attr_e($value) ?>"
                   type="text">
        </div>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/phonenumber/phonenumber.less');
$doc->addScriptApplySelector('.field-phonenumber','field_phonenumber',array(
    "input_name"=>  $name,
    "list_country"=>  $list,
),'admin/app/layouts/WooBooking/form/field/phonenumber/phonenumber.jquery.js');