<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Html\TourOperatorProHtmlBackend as TourOperatorProHtmlBackendAlias;
use TourOperatorPro\Language\Text;
defined('_TOUROPERATOR_EXEC') or die;
extract($displayData);

TourOperatorProHtmlBackendAlias::load_jquery_library('dateselect');



$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/mediabrowser/mediabrowser.less');
$id_by_name = "element_field_". $name;
$name_of_field = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-mediabrowser-<?php echo (esc_attr($name_of_field)) ?>">
        <div class="show-image"><img class="media-show" src="<?php echo($value) ?>"></div>
        <div class="input-group">
            <input name="<?php echo (esc_attr($name)); ?>" value="<?php echo (esc_attr($value)) ?>" type="text"
                   class="form-control">
            <span class="input-group-btn">
        <button class="btn btn-default btn-browser-media" type="button"><?php esc_html_e('Browser','touroperatorpro')?></button>
      </span>
        </div><!-- /input-group -->
    </div>
<?php
$doc->addScriptApplySelector('.field-mediabrowser-'.$name_of_field,'field_mediabrowser',array(
    "input_name"=>  $name,
    "multiple"=>  $multiple,
),'admin/app/layouts/WooBooking/form/field/mediabrowser/mediabrowser.jquery.js');
